/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Element;

public class Matcher {
    private Element element;
    private CharBuffer str;
    private int start;
    private int length;
    private boolean endOfString;

    protected Matcher(Element element, CharBuffer charBuffer) {
        this.element = element;
        this.str = charBuffer;
        this.start = 0;
        this.reset();
    }

    public void reset() {
        this.length = -1;
        this.endOfString = false;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        if (this.length > 0) {
            return this.start + this.length;
        }
        return this.start;
    }

    public int length() {
        return this.length;
    }

    public boolean hasReadEndOfString() {
        return this.endOfString;
    }

    void setReadEndOfString() {
        this.endOfString = true;
    }

    public boolean matchFromBeginning() {
        return this.matchFrom(0);
    }

    public boolean matchFrom(int n) {
        this.reset();
        this.start = n;
        this.length = this.element.match(this, this.str, this.start, 0);
        return this.length >= 0;
    }

    public String toString() {
        if (this.length <= 0) {
            return "";
        }
        return this.str.substring(this.start, this.start + this.length);
    }
}

