/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

public class CharBuffer {
    private int length = 0;
    private char[] contents = null;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int n) {
        this.contents = new char[n];
    }

    public CharBuffer(String string) {
        this.length = string.length();
        this.contents = string.toCharArray();
    }

    public CharBuffer(StringBuffer stringBuffer) {
        this.length = stringBuffer.length();
        this.contents = new char[this.length];
        stringBuffer.getChars(0, this.length, this.contents, 0);
    }

    public CharBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public CharBuffer append(char c) {
        this.ensureCapacity(this.length + 1);
        this.contents[this.length++] = c;
        return this;
    }

    public CharBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public CharBuffer append(char[] cArray, int n, int n2) {
        this.ensureCapacity(this.length + n2);
        System.arraycopy(cArray, n, this.contents, this.length, n2);
        this.length += n2;
        return this;
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public CharBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public CharBuffer append(Object object) {
        return this.append(object.toString());
    }

    public CharBuffer append(String string) {
        this.ensureCapacity(this.length + string.length());
        string.getChars(0, string.length(), this.contents, this.length);
        this.length += string.length();
        return this;
    }

    public CharBuffer append(StringBuffer stringBuffer) {
        this.ensureCapacity(this.length + stringBuffer.length());
        stringBuffer.getChars(0, stringBuffer.length(), this.contents, this.length);
        this.length += stringBuffer.length();
        return this;
    }

    public char charAt(int n) throws StringIndexOutOfBoundsException {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.contents[n];
    }

    public CharBuffer delete(int n, int n2) throws StringIndexOutOfBoundsException {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 - n > 0) {
            System.arraycopy(this.contents, n2, this.contents, n, this.length - n2);
            this.length -= n2 - n;
        }
        return this;
    }

    public void ensureCapacity(int n) {
        if (this.contents.length >= n) {
            return;
        }
        if (n < 2 * this.contents.length + 2) {
            n = 2 * this.contents.length + 2;
        }
        char[] cArray = new char[n];
        System.arraycopy(this.contents, 0, cArray, 0, this.length);
        this.contents = cArray;
    }

    public int length() {
        return this.length;
    }

    public String substring(int n) throws StringIndexOutOfBoundsException {
        return this.substring(n, this.length);
    }

    public String substring(int n, int n2) throws StringIndexOutOfBoundsException {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.contents, n, n2 - n);
    }

    public String toString() {
        return new String(this.contents, 0, this.length);
    }
}

