/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.RegExp;
import net.percederberg.grammatica.parser.re.RegExpException;

public class Tokenizer {
    private boolean useTokenList = false;
    private StringTokenMatcher stringMatcher = new StringTokenMatcher();
    private ArrayList regexpMatchers = new ArrayList();
    private Reader input = null;
    private CharBuffer buffer = new CharBuffer();
    private int position = 0;
    private int line = 1;
    private int column = 1;
    private boolean endOfBuffer = false;
    private Token previousToken = null;

    public Tokenizer(Reader reader) {
        this.input = reader;
    }

    public boolean getUseTokenList() {
        return this.useTokenList;
    }

    public void setUseTokenList(boolean bl) {
        this.useTokenList = bl;
    }

    public String getPatternDescription(int n) {
        TokenPattern tokenPattern = this.stringMatcher.getPattern(n);
        if (tokenPattern != null) {
            return tokenPattern.toShortString();
        }
        int n2 = 0;
        while (n2 < this.regexpMatchers.size()) {
            RegExpTokenMatcher regExpTokenMatcher = (RegExpTokenMatcher)this.regexpMatchers.get(n2);
            if (regExpTokenMatcher.getPattern().getId() == n) {
                return regExpTokenMatcher.getPattern().toShortString();
            }
            ++n2;
        }
        return null;
    }

    public int getCurrentLine() {
        return this.line;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public void addPattern(TokenPattern tokenPattern) throws ParserCreationException {
        switch (tokenPattern.getType()) {
            case 1: {
                this.stringMatcher.addPattern(tokenPattern);
                break;
            }
            case 2: {
                try {
                    this.regexpMatchers.add(new RegExpTokenMatcher(tokenPattern));
                    break;
                }
                catch (RegExpException regExpException) {
                    throw new ParserCreationException(2, tokenPattern.getName(), "regular expression contains error(s): " + regExpException.getMessage());
                }
            }
            default: {
                throw new ParserCreationException(2, tokenPattern.getName(), "pattern type " + tokenPattern.getType() + " is undefined");
            }
        }
    }

    public Token next() throws ParseException {
        Token token = null;
        do {
            token = this.nextToken();
            if (this.useTokenList && token != null) {
                token.setPreviousToken(this.previousToken);
                this.previousToken = token;
            }
            if (token == null) {
                return null;
            }
            if (token.getPattern().isError()) {
                throw new ParseException(5, token.getPattern().getErrorMessage(), token.getStartLine(), token.getStartColumn());
            }
            if (!token.getPattern().isIgnore()) continue;
            token = null;
        } while (token == null);
        return token;
    }

    private Token nextToken() throws ParseException {
        TokenMatcher tokenMatcher;
        do {
            if (this.endOfBuffer) {
                this.readInput();
                this.endOfBuffer = false;
            }
            tokenMatcher = this.findMatch();
        } while (this.endOfBuffer && this.input != null);
        if (tokenMatcher != null) {
            String string = this.buffer.substring(this.position, this.position + tokenMatcher.getMatchedLength());
            Token token = new Token(tokenMatcher.getMatchedPattern(), string, this.line, this.column);
            this.position += tokenMatcher.getMatchedLength();
            this.line = token.getEndLine();
            this.column = token.getEndColumn() + 1;
            return token;
        }
        if (this.position >= this.buffer.length()) {
            return null;
        }
        ParseException parseException = new ParseException(3, String.valueOf(this.buffer.charAt(this.position)), this.line, this.column);
        if (this.buffer.charAt(this.position) == '\n') {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        ++this.position;
        throw parseException;
    }

    private void readInput() throws ParseException {
        int n;
        char[] cArray = new char[4096];
        if (this.input == null) {
            return;
        }
        if (this.position > 1024) {
            this.buffer.delete(0, this.position);
            this.position = 0;
        }
        try {
            n = this.input.read(cArray);
        }
        catch (IOException iOException) {
            this.input = null;
            throw new ParseException(1, iOException.getMessage(), -1, -1);
        }
        if (n > 0) {
            this.buffer.append(cArray, 0, n);
        }
        if (n < cArray.length) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
    }

    private TokenMatcher findMatch() {
        TokenMatcher tokenMatcher = null;
        int n = 0;
        if (this.stringMatcher.matchFrom(this.position)) {
            tokenMatcher = this.stringMatcher;
            n = tokenMatcher.getMatchedLength();
        }
        if (this.stringMatcher.hasReadEndOfString()) {
            this.endOfBuffer = true;
        }
        int n2 = 0;
        while (n2 < this.regexpMatchers.size()) {
            RegExpTokenMatcher regExpTokenMatcher = (RegExpTokenMatcher)this.regexpMatchers.get(n2);
            if (regExpTokenMatcher.matchFrom(this.position) && regExpTokenMatcher.getMatchedLength() > n) {
                tokenMatcher = regExpTokenMatcher;
                n = tokenMatcher.getMatchedLength();
            }
            if (regExpTokenMatcher.hasReadEndOfString()) {
                this.endOfBuffer = true;
            }
            ++n2;
        }
        return tokenMatcher;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stringMatcher);
        int n = 0;
        while (n < this.regexpMatchers.size()) {
            stringBuffer.append(this.regexpMatchers.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    private class AutomatonTree {
        private char value = '\u0000';
        private Automaton state = null;
        private AutomatonTree left = null;
        private AutomatonTree right = null;

        public Automaton find(char c) {
            if (this.value == '\u0000' || this.value == c) {
                return this.state;
            }
            if (this.value > c) {
                return this.left.find(c);
            }
            return this.right.find(c);
        }

        public void add(char c, Automaton automaton) {
            if (this.value == '\u0000') {
                this.value = c;
                this.state = automaton;
                this.left = new AutomatonTree();
                this.right = new AutomatonTree();
            } else if (this.value > c) {
                this.left.add(c, automaton);
            } else {
                this.right.add(c, automaton);
            }
        }
    }

    private class Automaton {
        private Object value = null;
        private AutomatonTree tree = new AutomatonTree();

        public void addMatch(String string, Object object) {
            if (string.equals("")) {
                this.value = object;
            } else {
                Automaton automaton = this.tree.find(string.charAt(0));
                if (automaton == null) {
                    automaton = new Automaton();
                    automaton.addMatch(string.substring(1), object);
                    this.tree.add(string.charAt(0), automaton);
                } else {
                    automaton.addMatch(string.substring(1), object);
                }
            }
        }

        public Object matchFrom(StringTokenMatcher stringTokenMatcher, int n) {
            Automaton automaton;
            Object object = null;
            if (n >= Tokenizer.this.buffer.length()) {
                stringTokenMatcher.setReadEndOfString();
            } else if (this.tree != null && (automaton = this.tree.find(Tokenizer.this.buffer.charAt(n))) != null) {
                object = automaton.matchFrom(stringTokenMatcher, n + 1);
            }
            return object == null ? this.value : object;
        }
    }

    private class StringTokenMatcher
    extends TokenMatcher {
        private ArrayList patterns = new ArrayList();
        private Automaton start = new Automaton();
        private TokenPattern match = null;
        private boolean endOfString = false;

        public void reset() {
            this.match = null;
            this.endOfString = false;
        }

        public TokenPattern getMatchedPattern() {
            return this.match;
        }

        public int getMatchedLength() {
            if (this.match == null) {
                return 0;
            }
            return this.match.getPattern().length();
        }

        public boolean hasReadEndOfString() {
            return this.endOfString;
        }

        public void setReadEndOfString() {
            this.endOfString = true;
        }

        public TokenPattern getPattern(int n) {
            int n2 = 0;
            while (n2 < this.patterns.size()) {
                TokenPattern tokenPattern = (TokenPattern)this.patterns.get(n2);
                if (tokenPattern.getId() == n) {
                    return tokenPattern;
                }
                ++n2;
            }
            return null;
        }

        public void addPattern(TokenPattern tokenPattern) {
            this.patterns.add(tokenPattern);
            this.start.addMatch(tokenPattern.getPattern(), tokenPattern);
        }

        public boolean matchFrom(int n) {
            this.reset();
            this.match = (TokenPattern)this.start.matchFrom(this, n);
            return this.match != null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.patterns.size()) {
                stringBuffer.append(this.patterns.get(n));
                stringBuffer.append("\n\n");
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    private class RegExpTokenMatcher
    extends TokenMatcher {
        private TokenPattern pattern;
        private RegExp regExp;
        private Matcher matcher;

        public RegExpTokenMatcher(TokenPattern tokenPattern) throws RegExpException {
            this.pattern = tokenPattern;
            this.regExp = new RegExp(tokenPattern.getPattern());
            this.matcher = this.regExp.matcher(Tokenizer.this.buffer);
        }

        public TokenPattern getPattern() {
            return this.pattern;
        }

        public int start() {
            if (this.matcher.length() <= 0) {
                return 0;
            }
            return this.matcher.start();
        }

        public TokenPattern getMatchedPattern() {
            if (this.matcher.length() <= 0) {
                return null;
            }
            return this.pattern;
        }

        public int getMatchedLength() {
            return this.matcher.length();
        }

        public boolean hasReadEndOfString() {
            return this.matcher.hasReadEndOfString();
        }

        public boolean matchFrom(int n) {
            return this.matcher.matchFrom(n);
        }

        public String toString() {
            return this.pattern.toString() + "\n" + this.regExp.toString() + "\n";
        }
    }

    private abstract class TokenMatcher {
        private TokenMatcher() {
        }

        public abstract TokenPattern getMatchedPattern();

        public abstract int getMatchedLength();

        public abstract boolean hasReadEndOfString();
    }
}

