/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.AbstractList;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternElement;

public class ProductionPatternAlternative {
    private ProductionPattern pattern;
    private ArrayList elements = new ArrayList();
    private LookAheadSet lookAhead = null;

    public boolean isLeftRecursive() {
        int n = 0;
        while (n < this.elements.size()) {
            ProductionPatternElement productionPatternElement = (ProductionPatternElement)this.elements.get(n);
            if (productionPatternElement.getId() == this.pattern.getId()) {
                return true;
            }
            if (productionPatternElement.getMinCount() > 0) break;
            ++n;
        }
        return false;
    }

    public boolean isRightRecursive() {
        int n = this.elements.size() - 1;
        while (n >= 0) {
            ProductionPatternElement productionPatternElement = (ProductionPatternElement)this.elements.get(n);
            if (productionPatternElement.getId() == this.pattern.getId()) {
                return true;
            }
            if (productionPatternElement.getMinCount() > 0) break;
            --n;
        }
        return false;
    }

    public boolean isMatchingEmpty() {
        return this.getMinElementCount() == 0;
    }

    public ProductionPattern getPattern() {
        return this.pattern;
    }

    void setPattern(ProductionPattern productionPattern) {
        this.pattern = productionPattern;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public int getMinElementCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.size()) {
            ProductionPatternElement productionPatternElement = (ProductionPatternElement)this.elements.get(n2);
            n += productionPatternElement.getMinCount();
            ++n2;
        }
        return n;
    }

    public int getMaxElementCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.size()) {
            ProductionPatternElement productionPatternElement = (ProductionPatternElement)this.elements.get(n2);
            if (productionPatternElement.getMaxCount() >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            n += productionPatternElement.getMaxCount();
            ++n2;
        }
        return n;
    }

    public ProductionPatternElement getElement(int n) {
        return (ProductionPatternElement)this.elements.get(n);
    }

    public void addToken(int n, int n2, int n3) {
        this.addElement(new ProductionPatternElement(true, n, n2, n3));
    }

    public void addProduction(int n, int n2, int n3) {
        this.addElement(new ProductionPatternElement(false, n, n2, n3));
    }

    public void addElement(ProductionPatternElement productionPatternElement) {
        this.elements.add(productionPatternElement);
    }

    public void addElement(ProductionPatternElement productionPatternElement, int n, int n2) {
        if (productionPatternElement.isToken()) {
            this.addToken(productionPatternElement.getId(), n, n2);
        } else {
            this.addProduction(productionPatternElement.getId(), n, n2);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ProductionPatternAlternative) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)object;
            return ((AbstractList)this.elements).equals(productionPatternAlternative.elements);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.elements.size()) {
            if (n > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.elements.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAheadSet) {
        this.lookAhead = lookAheadSet;
    }
}

