/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;

public class ProductionPattern {
    private int id;
    private String name;
    private boolean syntetic;
    private ArrayList alternatives;
    private int defaultAlt;
    private LookAheadSet lookAhead;

    public ProductionPattern(int n, String string) {
        this.id = n;
        this.name = string;
        this.syntetic = false;
        this.alternatives = new ArrayList();
        this.defaultAlt = -1;
        this.lookAhead = null;
    }

    public boolean isSyntetic() {
        return this.syntetic;
    }

    public boolean isLeftRecursive() {
        int n = 0;
        while (n < this.alternatives.size()) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.alternatives.get(n);
            if (productionPatternAlternative.isLeftRecursive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isRightRecursive() {
        int n = 0;
        while (n < this.alternatives.size()) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.alternatives.get(n);
            if (productionPatternAlternative.isRightRecursive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isMatchingEmpty() {
        int n = 0;
        while (n < this.alternatives.size()) {
            ProductionPatternAlternative productionPatternAlternative = (ProductionPatternAlternative)this.alternatives.get(n);
            if (productionPatternAlternative.isMatchingEmpty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setSyntetic(boolean bl) {
        this.syntetic = bl;
    }

    public int getAlternativeCount() {
        return this.alternatives.size();
    }

    public ProductionPatternAlternative getAlternative(int n) {
        return (ProductionPatternAlternative)this.alternatives.get(n);
    }

    public void addAlternative(ProductionPatternAlternative productionPatternAlternative) throws ParserCreationException {
        if (this.alternatives.contains(productionPatternAlternative)) {
            throw new ParserCreationException(3, this.name, "two identical alternatives exist");
        }
        productionPatternAlternative.setPattern(this);
        this.alternatives.add(productionPatternAlternative);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        stringBuffer.append(this.id);
        stringBuffer.append(") ");
        int n = 0;
        while (n < stringBuffer.length()) {
            stringBuffer2.append(" ");
            ++n;
        }
        n = 0;
        while (n < this.alternatives.size()) {
            if (n == 0) {
                stringBuffer.append("= ");
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("| ");
            }
            stringBuffer.append(this.alternatives.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAheadSet) {
        this.lookAhead = lookAheadSet;
    }

    ProductionPatternAlternative getDefaultAlternative() {
        if (this.defaultAlt >= 0) {
            Object e = this.alternatives.get(this.defaultAlt);
            return (ProductionPatternAlternative)e;
        }
        return null;
    }

    void setDefaultAlternative(int n) {
        if (n >= 0 && n < this.alternatives.size()) {
            this.defaultAlt = n;
        }
    }
}

