/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

public abstract class Parser {
    private boolean initialized = false;
    private Tokenizer tokenizer;
    private Analyzer analyzer;
    private ArrayList patterns = new ArrayList();
    private HashMap patternIds = new HashMap();
    private ArrayList tokens = new ArrayList();
    private ParserLogException errorLog = new ParserLogException();
    private int errorRecovery = -1;

    Parser(Tokenizer tokenizer) {
        this(tokenizer, null);
    }

    Parser(Tokenizer tokenizer, Analyzer analyzer) {
        this.tokenizer = tokenizer;
        this.analyzer = analyzer == null ? new Analyzer() : analyzer;
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public void addPattern(ProductionPattern productionPattern) throws ParserCreationException {
        Integer n = new Integer(productionPattern.getId());
        if (productionPattern.getAlternativeCount() <= 0) {
            throw new ParserCreationException(3, productionPattern.getName(), "no production alternatives are present (must have at least one)");
        }
        if (this.patternIds.containsKey(n)) {
            throw new ParserCreationException(3, productionPattern.getName(), "another pattern with the same id (" + n + ") has already been added");
        }
        this.patterns.add(productionPattern);
        this.patternIds.put(n, productionPattern);
        this.setInitialized(false);
    }

    public void prepare() throws ParserCreationException {
        if (this.patterns.size() <= 0) {
            throw new ParserCreationException(1, "no production patterns have been added");
        }
        int n = 0;
        while (n < this.patterns.size()) {
            this.checkPattern((ProductionPattern)this.patterns.get(n));
            ++n;
        }
        this.setInitialized(true);
    }

    private void checkPattern(ProductionPattern productionPattern) throws ParserCreationException {
        int n = 0;
        while (n < productionPattern.getAlternativeCount()) {
            this.checkRule(productionPattern.getName(), productionPattern.getAlternative(n));
            ++n;
        }
    }

    private void checkRule(String string, ProductionPatternAlternative productionPatternAlternative) throws ParserCreationException {
        int n = 0;
        while (n < productionPatternAlternative.getElementCount()) {
            this.checkElement(string, productionPatternAlternative.getElement(n));
            ++n;
        }
    }

    private void checkElement(String string, ProductionPatternElement productionPatternElement) throws ParserCreationException {
        if (productionPatternElement.isProduction() && this.getPattern(productionPatternElement.getId()) == null) {
            throw new ParserCreationException(3, string, "an undefined production pattern id (" + productionPatternElement.getId() + ") is referenced");
        }
    }

    public Node parse() throws ParserCreationException, ParserLogException {
        Node node = null;
        if (!this.initialized) {
            this.prepare();
        }
        try {
            node = this.parseStart();
        }
        catch (ParseException parseException) {
            this.addError(parseException, true);
        }
        if (this.errorLog.getErrorCount() > 0) {
            throw this.errorLog;
        }
        return node;
    }

    protected abstract Node parseStart() throws ParseException;

    void addError(ParseException parseException, boolean bl) {
        if (this.errorRecovery <= 0) {
            this.errorLog.addError(parseException);
        }
        if (bl) {
            this.errorRecovery = 3;
        }
    }

    ProductionPattern getPattern(int n) {
        Integer n2 = new Integer(n);
        return (ProductionPattern)this.patternIds.get(n2);
    }

    ProductionPattern getStartPattern() {
        if (this.patterns.size() <= 0) {
            return null;
        }
        return (ProductionPattern)this.patterns.get(0);
    }

    Collection getPatterns() {
        return this.patterns;
    }

    void enterNode(Node node) {
        block2: {
            if (node.isHidden() || this.errorRecovery >= 0) break block2;
            try {
                this.analyzer.enter(node);
            }
            catch (ParseException parseException) {
                this.addError(parseException, false);
            }
        }
    }

    Node exitNode(Node node) {
        if (!node.isHidden() && this.errorRecovery < 0) {
            try {
                return this.analyzer.exit(node);
            }
            catch (ParseException parseException) {
                this.addError(parseException, false);
            }
        }
        return node;
    }

    void addNode(Production production, Node node) {
        block7: {
            if (this.errorRecovery >= 0) break block7;
            if (production.isHidden()) {
                production.addChild(node);
            } else if (node != null && node.isHidden()) {
                int n = 0;
                while (n < node.getChildCount()) {
                    this.addNode(production, node.getChildAt(n));
                    ++n;
                }
            } else {
                try {
                    this.analyzer.child(production, node);
                }
                catch (ParseException parseException) {
                    this.addError(parseException, false);
                }
            }
        }
    }

    Token nextToken() throws ParseException {
        Token token = this.peekToken(0);
        if (token != null) {
            this.tokens.remove(0);
            return token;
        }
        throw new ParseException(2, null, this.tokenizer.getCurrentLine(), this.tokenizer.getCurrentColumn());
    }

    Token nextToken(int n) throws ParseException {
        Token token = this.nextToken();
        if (token.getId() == n) {
            if (this.errorRecovery > 0) {
                --this.errorRecovery;
            }
            return token;
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(this.tokenizer.getPatternDescription(n));
        throw new ParseException(4, token.toShortString(), arrayList, token.getStartLine(), token.getStartColumn());
    }

    Token peekToken(int n) {
        while (n >= this.tokens.size()) {
            try {
                Token token = this.tokenizer.next();
                if (token == null) {
                    return null;
                }
                this.tokens.add(token);
            }
            catch (ParseException parseException) {
                this.addError(parseException, true);
            }
        }
        return (Token)this.tokens.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.patterns.size()) {
            stringBuffer.append(this.toString((ProductionPattern)this.patterns.get(n)));
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private String toString(ProductionPattern productionPattern) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(productionPattern.getName());
        stringBuffer.append(" (");
        stringBuffer.append(productionPattern.getId());
        stringBuffer.append(") ");
        int n = 0;
        while (n < stringBuffer.length()) {
            stringBuffer2.append(" ");
            ++n;
        }
        stringBuffer.append("= ");
        stringBuffer2.append("| ");
        n = 0;
        while (n < productionPattern.getAlternativeCount()) {
            if (n > 0) {
                stringBuffer.append(stringBuffer2);
            }
            stringBuffer.append(this.toString(productionPattern.getAlternative(n)));
            stringBuffer.append("\n");
            ++n;
        }
        n = 0;
        while (n < productionPattern.getAlternativeCount()) {
            LookAheadSet lookAheadSet = productionPattern.getAlternative(n).getLookAhead();
            if (lookAheadSet.getMaxLength() > 1) {
                stringBuffer.append("Using ");
                stringBuffer.append(lookAheadSet.getMaxLength());
                stringBuffer.append(" token look-ahead for alternative ");
                stringBuffer.append(n + 1);
                stringBuffer.append(": ");
                stringBuffer.append(lookAheadSet.toString(this.tokenizer));
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String toString(ProductionPatternAlternative productionPatternAlternative) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < productionPatternAlternative.getElementCount()) {
            if (n > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.toString(productionPatternAlternative.getElement(n)));
            ++n;
        }
        return stringBuffer.toString();
    }

    private String toString(ProductionPatternElement productionPatternElement) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = productionPatternElement.getMinCount();
        int n2 = productionPatternElement.getMaxCount();
        if (n == 0 && n2 == 1) {
            stringBuffer.append("[");
        }
        if (productionPatternElement.isToken()) {
            stringBuffer.append(this.getTokenDescription(productionPatternElement.getId()));
        } else {
            stringBuffer.append(this.getPattern(productionPatternElement.getId()).getName());
        }
        if (n == 0 && n2 == 1) {
            stringBuffer.append("]");
        } else if (n == 0 && n2 == Integer.MAX_VALUE) {
            stringBuffer.append("*");
        } else if (n == 1 && n2 == Integer.MAX_VALUE) {
            stringBuffer.append("+");
        } else if (n != 1 || n2 != 1) {
            stringBuffer.append("{");
            stringBuffer.append(n);
            stringBuffer.append(",");
            stringBuffer.append(n2);
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    String getTokenDescription(int n) {
        if (this.tokenizer == null) {
            return "";
        }
        return this.tokenizer.getPatternDescription(n);
    }
}

