/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.grammatica.parser.Production;

public class Analyzer {
    public Node analyze(Node node) throws ParserLogException {
        ParserLogException parserLogException = new ParserLogException();
        node = this.analyze(node, parserLogException);
        if (parserLogException.getErrorCount() > 0) {
            throw parserLogException;
        }
        return node;
    }

    private Node analyze(Node node, ParserLogException parserLogException) {
        block12: {
            int n = parserLogException.getErrorCount();
            if (node instanceof Production) {
                Production production = (Production)node;
                production = new Production(production.getPattern());
                try {
                    this.enter(production);
                }
                catch (ParseException parseException) {
                    parserLogException.addError(parseException);
                }
                int n2 = 0;
                while (n2 < node.getChildCount()) {
                    try {
                        this.child(production, this.analyze(node.getChildAt(n2), parserLogException));
                    }
                    catch (ParseException parseException) {
                        parserLogException.addError(parseException);
                    }
                    ++n2;
                }
                try {
                    return this.exit(production);
                }
                catch (ParseException parseException) {
                    if (n != parserLogException.getErrorCount()) break block12;
                    parserLogException.addError(parseException);
                    break block12;
                }
            }
            node.removeAllValues();
            try {
                this.enter(node);
            }
            catch (ParseException parseException) {
                parserLogException.addError(parseException);
            }
            try {
                return this.exit(node);
            }
            catch (ParseException parseException) {
                if (n != parserLogException.getErrorCount()) break block12;
                parserLogException.addError(parseException);
            }
        }
        return null;
    }

    protected void enter(Node node) throws ParseException {
    }

    protected Node exit(Node node) throws ParseException {
        return node;
    }

    protected void child(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected Node getChildAt(Node node, int n) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Node node2 = node.getChildAt(n);
        if (node2 == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no child at " + "position " + n, node.getStartLine(), node.getStartColumn());
        }
        return node2;
    }

    protected Node getChildWithId(Node node, int n) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        int n2 = 0;
        while (n2 < node.getChildCount()) {
            Node node2 = node.getChildAt(n2);
            if (node2 != null && node2.getId() == n) {
                return node2;
            }
            ++n2;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no child with id " + n, node.getStartLine(), node.getStartColumn());
    }

    protected Object getValue(Node node, int n) throws ParseException {
        if (node == null) {
            throw new ParseException(0, "attempt to read 'null' parse tree node", -1, -1);
        }
        Object object = node.getValue(n);
        if (object == null) {
            throw new ParseException(0, "node '" + node.getName() + "' has no value at " + "position " + n, node.getStartLine(), node.getStartColumn());
        }
        return object;
    }

    protected int getIntValue(Node node, int n) throws ParseException {
        Object object = this.getValue(node, n);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no integer value " + "at position " + n, node.getStartLine(), node.getStartColumn());
    }

    protected String getStringValue(Node node, int n) throws ParseException {
        Object object = this.getValue(node, n);
        if (object instanceof String) {
            return (String)object;
        }
        throw new ParseException(0, "node '" + node.getName() + "' has no string value " + "at position " + n, node.getStartLine(), node.getStartColumn());
    }

    protected ArrayList getChildValues(Node node) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < node.getChildCount()) {
            Node node2 = node.getChildAt(n);
            ArrayList arrayList2 = node2.getAllValues();
            if (arrayList2 != null) {
                arrayList.addAll(arrayList2);
            }
            ++n;
        }
        return arrayList;
    }
}

