/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.NumberValue;

public class SnmpTrapType
extends SnmpType {
    private MibValue enterprise;
    private ArrayList variables;
    private String reference;

    public SnmpTrapType(MibValue enterprise, ArrayList variables, String description, String reference) {
        super("TRAP-TYPE", description);
        this.enterprise = enterprise;
        this.variables = variables;
        this.reference = reference;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        ArrayList<MibValue> list = new ArrayList<MibValue>();
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        this.enterprise = this.enterprise.initialize(log, null);
        for (int i = 0; i < this.variables.size(); ++i) {
            list.add(((MibValue)this.variables.get(i)).initialize(log, null));
        }
        this.variables = list;
        return this;
    }

    public boolean isCompatible(MibValue value) {
        return value instanceof NumberValue && !(value.toObject() instanceof Float);
    }

    public MibValue getEnterprise() {
        return this.enterprise;
    }

    public ArrayList getVariables() {
        return this.variables;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Enterprise: ");
        buffer.append(this.enterprise);
        buffer.append("\n  Variables: ");
        buffer.append(this.variables);
        if (this.getUnformattedDescription() != null) {
            buffer.append("\n  Description: ");
            buffer.append(this.getDescription("               "));
        }
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

