/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.MibbleBrowser;
import net.percederberg.mibble.browser.AboutDialog;
import net.percederberg.mibble.browser.LicenseDialog;
import net.percederberg.mibble.browser.MibNode;
import net.percederberg.mibble.browser.MibTreeBuilder;
import net.percederberg.mibble.browser.SnmpPanel;

public class BrowserFrame
extends JFrame {
    private MibbleBrowser browser;
    private JMenuBar menuBar = new JMenuBar();
    private JCheckBoxMenuItem snmpV1Item = new JCheckBoxMenuItem("SNMP version 1");
    private JCheckBoxMenuItem snmpV2Item = new JCheckBoxMenuItem("SNMP version 2c");
    private JCheckBoxMenuItem snmpV3Item = new JCheckBoxMenuItem("SNMP version 3");
    private JTextArea descriptionArea = new JTextArea();
    private JLabel statusLabel = new JLabel("Ready");
    private JTree mibTree = null;
    private SnmpPanel snmpPanel = null;
    private File currentDir = new File(".");

    public BrowserFrame(MibbleBrowser browser) {
        this.browser = browser;
        String dir = System.getProperty("user.dir");
        if (dir != null) {
            this.currentDir = new File(dir);
        }
        this.initialize();
    }

    private void initialize() {
        Rectangle bounds = new Rectangle();
        JSplitPane horizontalSplitPane = new JSplitPane();
        JSplitPane verticalSplitPane = new JSplitPane();
        this.setDefaultCloseOperation(3);
        this.setTitle("Mibble MIB Browser");
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        bounds.width = (int)((double)size.width * 0.75);
        bounds.height = (int)((double)size.height * 0.75);
        bounds.x = (size.width - bounds.width) / 2;
        bounds.y = (size.height - bounds.height) / 2;
        this.setBounds(bounds);
        this.setJMenuBar(this.menuBar);
        this.initializeMenu();
        this.getContentPane().setLayout(new GridBagLayout());
        horizontalSplitPane.setDividerLocation((int)((double)bounds.width * 0.35));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getContentPane().add((Component)horizontalSplitPane, c);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.fill = 1;
        c.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.statusLabel, c);
        this.mibTree = MibTreeBuilder.getInstance().getTree();
        this.mibTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                BrowserFrame.this.updateTreeSelection();
            }
        });
        horizontalSplitPane.setLeftComponent(new JScrollPane(this.mibTree));
        verticalSplitPane.setOrientation(0);
        verticalSplitPane.setDividerLocation((int)((double)bounds.height * 0.4));
        verticalSplitPane.setOneTouchExpandable(true);
        this.descriptionArea.setEditable(false);
        verticalSplitPane.setLeftComponent(new JScrollPane(this.descriptionArea));
        this.snmpPanel = new SnmpPanel(this);
        verticalSplitPane.setRightComponent(this.snmpPanel);
        horizontalSplitPane.setRightComponent(verticalSplitPane);
    }

    private void initializeMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("Load MIB...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.loadMib();
            }
        });
        menu.add(item);
        item = new JMenuItem("Unload MIB");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.unloadMib();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Exit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(item);
        this.menuBar.add(menu);
        menu = new JMenu("SNMP");
        this.snmpV1Item.setSelected(true);
        this.snmpV1Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.setSnmpVersion(1);
            }
        });
        menu.add(this.snmpV1Item);
        this.snmpV2Item.setSelected(false);
        this.snmpV2Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.setSnmpVersion(2);
            }
        });
        menu.add(this.snmpV2Item);
        this.snmpV3Item.setSelected(false);
        this.snmpV3Item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.setSnmpVersion(3);
            }
        });
        menu.add(this.snmpV3Item);
        menu.addSeparator();
        JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem("Show result in tree");
        checkBox.setSelected(true);
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem src = (JCheckBoxMenuItem)e.getSource();
                BrowserFrame.this.setSnmpFeedback(src.isSelected());
            }
        });
        menu.add(checkBox);
        this.menuBar.add(menu);
        menu = new JMenu("Help");
        item = new JMenuItem("License...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.showLicense();
            }
        });
        menu.add(item);
        item = new JMenuItem("About...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.this.showAbout();
            }
        });
        menu.add(item);
        this.menuBar.add(menu);
    }

    public void setBlocked(boolean blocked) {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            this.menuBar.getMenu(i).setEnabled(!blocked);
        }
        this.snmpPanel.setBlocked(blocked);
    }

    protected void loadMib() {
        File[] files;
        JFileChooser dialog = new JFileChooser();
        dialog.setCurrentDirectory(this.currentDir);
        dialog.setMultiSelectionEnabled(true);
        int result = dialog.showOpenDialog(this);
        if (result == 0 && (files = dialog.getSelectedFiles()).length > 0) {
            this.currentDir = files[0].getParentFile();
            this.descriptionArea.setText("");
            Loader loader = new Loader(files);
            loader.start();
        }
    }

    public void loadMib(String src) {
        String message = null;
        this.setStatus("Loading " + src + "...");
        try {
            this.browser.loadMib(src);
        }
        catch (FileNotFoundException e) {
            message = "Failed to load " + e.getMessage();
        }
        catch (IOException e) {
            message = "Failed to load " + src + ": " + e.getMessage();
        }
        catch (MibLoaderException e) {
            message = "Failed to load " + src;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            e.getLog().printTo(new PrintStream(output));
            this.descriptionArea.append(output.toString());
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "MIB Loading Error", 0);
        }
        this.setStatus(null);
    }

    protected void unloadMib() {
        MibNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        while (node.getLevel() > 1) {
            node = (MibNode)node.getParent();
        }
        this.browser.unloadMib(node.getName());
        this.refreshTree();
    }

    public void refreshTree() {
        ((DefaultTreeModel)this.mibTree.getModel()).reload();
        this.mibTree.repaint();
    }

    public void setSnmpVersion(int version) {
        this.snmpV1Item.setSelected(false);
        this.snmpV2Item.setSelected(false);
        this.snmpV3Item.setSelected(false);
        if (version == 1) {
            this.snmpV1Item.setSelected(true);
        } else if (version == 2) {
            this.snmpV2Item.setSelected(true);
        } else if (version == 3) {
            this.snmpV3Item.setSelected(true);
        }
        this.snmpPanel.setVersion(version);
    }

    public void setSnmpFeedback(boolean feedback) {
        this.snmpPanel.setFeedback(feedback);
    }

    public MibNode getSelectedNode() {
        return (MibNode)this.mibTree.getLastSelectedPathComponent();
    }

    public void setSelectedNode(String oid) {
        MibNode node = this.getSelectedNode();
        if (node == null || node.getSymbol() == null) {
            return;
        }
        MibValueSymbol symbol = node.getSymbol().getMib().getSymbolByOid(oid);
        if (symbol == null) {
            this.mibTree.clearSelection();
            return;
        }
        node = MibTreeBuilder.getInstance().getNode(symbol);
        TreePath path = new TreePath(node.getPath());
        this.mibTree.expandPath(path);
        this.mibTree.scrollPathToVisible(path);
        this.mibTree.setSelectionPath(path);
        this.mibTree.repaint();
    }

    public void setStatus(String text) {
        if (text != null) {
            this.statusLabel.setText(text);
        } else {
            this.statusLabel.setText("Ready");
        }
    }

    protected void showAbout() {
        AboutDialog dialog = new AboutDialog(this);
        dialog.setVisible(true);
    }

    protected void showLicense() {
        LicenseDialog dialog = new LicenseDialog(this);
        dialog.setVisible(true);
    }

    protected void updateTreeSelection() {
        MibNode node = this.getSelectedNode();
        if (node == null) {
            this.descriptionArea.setText("");
        } else {
            this.descriptionArea.setText(node.getDescription());
            this.descriptionArea.setCaretPosition(0);
        }
        this.snmpPanel.updateOid();
    }

    private class Loader
    implements Runnable {
        private File[] files;

        public Loader(File[] files) {
            this.files = files;
        }

        public void start() {
            if (this.files.length > 0) {
                Thread thread = new Thread(this);
                thread.start();
            }
        }

        public void run() {
            BrowserFrame.this.setBlocked(true);
            for (int i = 0; i < this.files.length; ++i) {
                BrowserFrame.this.loadMib(this.files[i].toString());
            }
            BrowserFrame.this.refreshTree();
            BrowserFrame.this.setBlocked(false);
        }
    }
}

