/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

public class MibTypeTag {
    public static final int UNIVERSAL_CATEGORY = 0;
    public static final int APPLICATION_CATEGORY = 1;
    public static final int CONTEXT_SPECIFIC_CATEGORY = 2;
    public static final int PRIVATE_CATEGORY = 3;
    public static final MibTypeTag BOOLEAN = new MibTypeTag(0, 1);
    public static final MibTypeTag INTEGER = new MibTypeTag(0, 2);
    public static final MibTypeTag BIT_STRING = new MibTypeTag(0, 3);
    public static final MibTypeTag OCTET_STRING = new MibTypeTag(0, 4);
    public static final MibTypeTag NULL = new MibTypeTag(0, 5);
    public static final MibTypeTag OBJECT_IDENTIFIER = new MibTypeTag(0, 6);
    public static final MibTypeTag REAL = new MibTypeTag(0, 9);
    public static final MibTypeTag SEQUENCE = new MibTypeTag(0, 16);
    public static final MibTypeTag SET = new MibTypeTag(0, 17);
    private int category;
    private int value;
    private MibTypeTag next = null;

    public MibTypeTag(int category, int value) {
        this.category = category;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MibTypeTag) {
            MibTypeTag tag = (MibTypeTag)obj;
            return this.equals(tag.category, tag.value);
        }
        return false;
    }

    public boolean equals(int category, int value) {
        return this.category == category && this.value == value;
    }

    public int hashCode() {
        return (this.category << 8) + this.value;
    }

    public int getCategory() {
        return this.category;
    }

    public int getValue() {
        return this.value;
    }

    public MibTypeTag getNext() {
        return this.next;
    }

    public void setNext(MibTypeTag next) {
        this.next = next;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.category == 0) {
            buffer.append("UNIVERSAL ");
        } else if (this.category == 1) {
            buffer.append("APPLICATION ");
        } else if (this.category == 3) {
            buffer.append("PRIVATE ");
        }
        buffer.append(this.value);
        buffer.append("]");
        if (this.next != null) {
            buffer.append(" ");
            buffer.append(this.next.toString());
        }
        return buffer.toString();
    }
}

