/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.DefaultContext;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibAnalyzer;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.asn1.Asn1Parser;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibLoader {
    private ArrayList dirs = new ArrayList();
    private ArrayList resources = new ArrayList();
    private ArrayList mibs = new ArrayList();
    private ArrayList queue = new ArrayList();
    private DefaultContext context = new DefaultContext();

    public MibLoader() {
        this.addResourceDir("mibs/iana");
        this.addResourceDir("mibs/ietf");
    }

    public void addDir(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        if (!this.dirs.contains(dir)) {
            this.dirs.add(dir);
        }
    }

    public void addDirs(File[] dirs) {
        for (int i = 0; i < dirs.length; ++i) {
            this.addDir(dirs[i]);
        }
    }

    public void addAllDirs(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        this.addDir(dir);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            this.addAllDirs(files[i]);
        }
    }

    public void removeDir(File dir) {
        this.dirs.remove(dir);
    }

    public void removeAllDirs() {
        this.dirs.clear();
    }

    public void addResourceDir(String dir) {
        if (!this.resources.contains(dir)) {
            this.resources.add(dir);
        }
    }

    public void removeResourceDir(String dir) {
        this.resources.remove(dir);
    }

    public void removeAllResourceDirs() {
        this.resources.clear();
    }

    public void reset() {
        this.mibs.clear();
        this.queue.clear();
        this.context = new DefaultContext();
    }

    public MibContext getDefaultContext() {
        return this.context;
    }

    public ObjectIdentifierValue getRootOid() {
        MibSymbol symbol = this.context.findSymbol("iso", false);
        MibValue value = ((MibValueSymbol)symbol).getValue();
        return (ObjectIdentifierValue)value;
    }

    public Mib getMib(String name) {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(name)) continue;
            return mib;
        }
        return null;
    }

    public Mib getMib(File file) {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(file)) continue;
            return mib;
        }
        return null;
    }

    public Mib[] getAllMibs() {
        Mib[] res = new Mib[this.mibs.size()];
        this.mibs.toArray(res);
        return res;
    }

    public Mib load(String name) throws IOException, MibLoaderException {
        Mib mib = this.getMib(name);
        if (mib == null) {
            MibSource src = this.locate(name);
            if (src == null) {
                throw new FileNotFoundException("couldn't locate MIB: '" + name + "'");
            }
            mib = this.load(src);
        } else {
            mib.setLoaded(true);
        }
        return mib;
    }

    public Mib load(File file) throws IOException, MibLoaderException {
        Mib mib = this.getMib(file);
        if (mib == null) {
            mib = this.load(new MibSource(file));
        } else {
            mib.setLoaded(true);
        }
        return mib;
    }

    public Mib load(URL url) throws IOException, MibLoaderException {
        return this.load(new MibSource(url));
    }

    public Mib load(Reader input) throws IOException, MibLoaderException {
        return this.load(new MibSource(input));
    }

    private Mib load(MibSource src) throws IOException, MibLoaderException {
        int position = this.mibs.size();
        this.queue.clear();
        this.queue.add(src);
        MibLoaderLog log = this.loadQueue();
        if (log.errorCount() > 0) {
            throw new MibLoaderException(log);
        }
        return (Mib)this.mibs.get(position);
    }

    public void unload(String name) throws MibLoaderException {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(name)) continue;
            this.unload(mib);
            return;
        }
    }

    public void unload(File file) throws MibLoaderException {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(file)) continue;
            this.unload(mib);
            return;
        }
    }

    public void unload(Mib mib) throws MibLoaderException {
        int pos = this.mibs.indexOf(mib);
        if (pos >= 0) {
            Mib[] referers = mib.getImportingMibs();
            if (referers.length > 0) {
                String message = "cannot be unloaded due to reference in " + referers[0];
                throw new MibLoaderException(mib.getFile(), message);
            }
            mib = (Mib)this.mibs.remove(pos);
            mib.clear();
        }
    }

    void scheduleLoad(String name) {
        if (this.getMib(name) == null && !this.queue.contains(name)) {
            this.queue.add(name);
        }
    }

    private MibLoaderLog loadQueue() throws IOException {
        int i;
        MibLoaderLog log = new MibLoaderLog();
        ArrayList processed = new ArrayList();
        while (this.queue.size() > 0) {
            try {
                MibSource src;
                boolean loaded = false;
                Object obj = this.queue.get(0);
                if (obj instanceof MibSource) {
                    loaded = true;
                    src = (MibSource)obj;
                } else {
                    src = this.getMib((String)obj) == null ? this.locate((String)obj) : null;
                }
                if (src != null && this.getMib(src.getFile()) == null) {
                    ArrayList list = src.parseMib(this, log);
                    for (i = 0; i < list.size(); ++i) {
                        ((Mib)list.get(i)).setLoaded(loaded);
                    }
                    this.mibs.addAll(list);
                    processed.addAll(list);
                }
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
            this.queue.remove(0);
        }
        for (i = processed.size() - 1; i >= 0; --i) {
            try {
                ((Mib)processed.get(i)).initialize();
                continue;
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
        }
        for (i = processed.size() - 1; i >= 0; --i) {
            try {
                ((Mib)processed.get(i)).validate();
                continue;
            }
            catch (MibLoaderException e) {
                // empty catch block
            }
        }
        if (log.errorCount() > 0) {
            this.mibs.removeAll(processed);
        }
        return log;
    }

    private MibSource locate(String name) {
        File[] files;
        File dir;
        int i;
        ClassLoader loader = this.getClass().getClassLoader();
        for (i = 0; i < this.dirs.size(); ++i) {
            dir = (File)this.dirs.get(i);
            files = dir.listFiles(new MibFileFilter(name));
            if (files == null || files.length <= 0) continue;
            return new MibSource(files[0]);
        }
        for (i = 0; i < this.resources.size(); ++i) {
            URL url = loader.getResource(this.resources.get(i) + "/" + name);
            if (url == null) continue;
            return new MibSource(name, url);
        }
        for (i = 0; i < this.dirs.size(); ++i) {
            dir = (File)this.dirs.get(i);
            files = dir.listFiles();
            for (int j = 0; files != null && j < files.length; ++j) {
                if (!this.isNamedMib(files[j], name)) continue;
                return new MibSource(files[j]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNamedMib(File file, String name) {
        block20: {
            BufferedReader in = null;
            if (!file.canRead() || !file.isFile()) {
                return false;
            }
            try {
                String str;
                in = new BufferedReader(new FileReader(file));
                do {
                    if ((str = in.readLine()) != null) continue;
                    break block20;
                } while ((str = str.trim()).equals("") || str.startsWith("--"));
                boolean bl = str.equals(name) || str.startsWith(name + " ") || str.startsWith(name + "\t");
                return bl;
            }
            catch (FileNotFoundException ignore) {
            }
            catch (IOException ignore) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return false;
    }

    private class MibFileFilter
    implements FilenameFilter {
        private String basename;

        public MibFileFilter(String name) {
            this.basename = name.toUpperCase();
        }

        public boolean accept(File dir, String name) {
            return (name = name.toUpperCase()).equals(this.basename) || name.startsWith(this.basename + ".");
        }
    }

    private class MibSource {
        private File file = null;
        private URL url = null;
        private Reader input = null;

        public MibSource(File file) {
            this.file = file;
        }

        public MibSource(URL url) {
            this.url = url;
        }

        public MibSource(String name, URL url) {
            this(url);
            this.file = new File(name);
        }

        public MibSource(Reader input) {
            this.input = input;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MibSource) {
                MibSource src = (MibSource)obj;
                if (this.url != null) {
                    return this.url.equals(src.url);
                }
                if (this.file != null) {
                    return this.file.equals(src.file);
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.url != null) {
                return this.url.hashCode();
            }
            if (this.file != null) {
                return this.file.hashCode();
            }
            return super.hashCode();
        }

        public File getFile() {
            return this.file;
        }

        public ArrayList parseMib(MibLoader loader, MibLoaderLog log) throws IOException, MibLoaderException {
            if (this.input == null) {
                this.input = this.url != null ? new InputStreamReader(this.url.openStream()) : new FileReader(this.file);
            }
            try {
                MibAnalyzer analyzer = new MibAnalyzer(this.file, loader, log);
                Asn1Parser parser = new Asn1Parser(this.input, analyzer);
                parser.getTokenizer().setUseTokenList(true);
                parser.parse();
                return analyzer.getMibs();
            }
            catch (ParserCreationException e) {
                String msg = "parser creation error in ASN.1 parser: " + e.getMessage();
                log.addInternalError(this.file, msg);
                throw new MibLoaderException(log);
            }
            catch (ParserLogException e) {
                log.addAll(this.file, e);
                throw new MibLoaderException(log);
            }
        }
    }
}

