/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.ArrayList;
import java.util.Collection;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;

public class MibImport
implements MibContext {
    private MibLoader loader;
    private Mib mib = null;
    private FileLocation location;
    private String name;
    private ArrayList symbols;

    MibImport(MibLoader loader, FileLocation location, String name, ArrayList symbols) {
        this.loader = loader;
        this.location = location;
        this.name = name;
        this.symbols = symbols;
    }

    public void initialize(MibLoaderLog log) throws MibException {
        this.mib = this.loader.getMib(this.name);
        if (this.mib == null) {
            String message = "couldn't find referenced MIB '" + this.name + "'";
            throw new MibException(this.location, message);
        }
        if (this.symbols != null) {
            for (int i = 0; i < this.symbols.size(); ++i) {
                if (this.mib.getSymbol(this.symbols.get(i).toString()) != null) continue;
                String message = "couldn't find imported symbol '" + this.symbols.get(i) + "' in MIB '" + this.name + "'";
                throw new MibException(this.location, message);
            }
        }
    }

    boolean hasSymbols() {
        return this.symbols != null;
    }

    public String getName() {
        return this.name;
    }

    public Mib getMib() {
        return this.mib;
    }

    public Collection getAllSymbolNames() {
        return this.symbols;
    }

    public MibSymbol findSymbol(String name, boolean expanded) {
        if (this.mib == null) {
            return null;
        }
        if (!expanded && this.symbols != null && !this.symbols.contains(name)) {
            return null;
        }
        return this.mib.getSymbol(name);
    }

    public String toString() {
        return this.name;
    }
}

