/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor.syslogng;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.monitor.ExportTestCaseMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportTestCaseMonitorSyslogng
extends ExportTestCaseMonitor {
    private static Log log = LogFactory.getLog(ExportTestCaseMonitorSyslogng.class);

    public void exportTestCase() {
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Syslogng.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<LogFilterInfo> arrayList2 = this.getSyslogngList();
        if (arrayList2 instanceof ArrayList) {
            for (LogFilterInfo logFilterInfo : arrayList2) {
                Object[] objectArray = new Object[]{logFilterInfo.getMonitorId()};
                log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.MonitorID", objectArray)));
                arrayList.addAll(this.createTestCase((MonitorInfo)logFilterInfo));
            }
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/SYSLOGNG_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Syslogng.End")));
    }

    @Override
    protected ArrayList<String> getFacilityIdList(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getNodeList(monitorInfo.getFacilityId()));
        return arrayList;
    }

    protected ArrayList<LogFilterInfo> getSyslogngList() {
        SyslogNGController syslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        ArrayList arrayList = null;
        try {
            arrayList = syslogNGController.getFilterInfoList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

