/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor.syslogng;

import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.MonitorSyslogNGController;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMonitorSyslogng {
    private static Log log = LogFactory.getLog(TestMonitorSyslogng.class);
    protected BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    protected HashMap<String, ArrayList<String>> messageMap = new HashMap();
    protected HashMap<String, ArrayList<String>> fileMap = new HashMap();
    protected static final ArrayList<String> attributeListTarget = new ArrayList();
    protected static final ArrayList<String> attributeListPlatform = new ArrayList();

    public static void main(String[] stringArray) {
        TestMonitorSyslogng testMonitorSyslogng = new TestMonitorSyslogng();
        testMonitorSyslogng.test();
    }

    public void test() {
        log.info((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.Syslogng.Start")));
        this.messageMap = this.getMessageMap();
        this.fileMap = this.getFileMap();
        for (String string : this.messageMap.keySet()) {
            Object[] objectArray = new Object[]{string};
            log.info((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.FacilityID", objectArray)));
            this.logger(string);
        }
        log.info((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.Syslogng.End")));
    }

    protected void logger(String string) {
        String string2 = this.getPlatform(string);
        if (string2.matches(".*(Linux|LINUX|linux).*")) {
            this.loggerLinux(string);
        } else if (string2.matches(".*(Windows|WINDOWS|windows).*")) {
            this.loggerWindows(string);
        }
    }

    protected void loggerLinux(String string) {
        try {
            String string2 = this.getTargetIP(string);
            JSch jSch = new JSch();
            System.out.println("Enter uid (" + string2 + ")");
            System.out.print("uid > ");
            String string3 = this.reader.readLine();
            Session session = jSch.getSession(string3, string2, 22);
            MyUserInfo myUserInfo = new MyUserInfo();
            session.setUserInfo((UserInfo)myUserInfo);
            session.connect();
            if (this.messageMap.get(string) instanceof ArrayList) {
                for (String string4 : this.messageMap.get(string)) {
                    String string52;
                    String string6 = "";
                    if (this.fileMap.get(string) instanceof ArrayList) {
                        for (String string52 : this.fileMap.get(string)) {
                            if (!string4.matches(".*" + string52 + ".*")) continue;
                            string6 = string52;
                            break;
                        }
                    }
                    Object object = "";
                    object = string6 == "" ? "logger '" + string4 + "'" : "echo '" + string4 + "' >> " + string6;
                    log.info((Object)("[" + Messages.getMsg("TestSyslog") + "] " + "Command Execute : " + (String)object));
                    System.out.println("Command Execute : " + (String)object);
                    string52 = session.openChannel("exec");
                    ((ChannelExec)string52).setCommand((String)object);
                    string52.setInputStream(null);
                    ((ChannelExec)string52).setErrStream((OutputStream)System.err);
                    InputStream inputStream = string52.getInputStream();
                    string52.connect();
                    byte[] byArray = new byte[1024];
                    while (true) {
                        int n;
                        String string7 = "";
                        while (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                            string7 = new String(byArray, 0, n);
                            System.out.print(string7);
                        }
                        if (string52.isClosed()) break;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                    log.info((Object)("[" + Messages.getMsg("TestSyslog") + "] " + "ExitCode : " + string52.getExitStatus()));
                    System.out.println("ExitCode : " + string52.getExitStatus());
                    string52.disconnect();
                }
            }
            session.disconnect();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
    }

    protected void loggerWindows(String string) {
    }

    protected String getPlatform(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        String string2 = "";
        if (string != null && !"".equals(string)) {
            try {
                HashMap hashMap = repositoryController.getNodeDetail(string, attributeListPlatform);
                string2 = (String)hashMap.get("ccPlatform");
            }
            catch (Exception exception) {
                log.error((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
                System.exit(14);
            }
        }
        return string2;
    }

    protected String getTargetIP(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        int n = 4;
        String string2 = "";
        if (string != null && !"".equals(string)) {
            try {
                HashMap hashMap = repositoryController.getNodeDetail(string, attributeListTarget);
                n = (Integer)hashMap.get("ipProtocolNumber") != null ? (Integer)hashMap.get("ipProtocolNumber") : 4;
                if (n == 6) {
                    InetAddress[] inetAddressArray = InetAddress.getAllByName((String)hashMap.get("ccIpNetworkNumberV6"));
                    if (inetAddressArray.length != 1) {
                        throw new UnknownHostException();
                    }
                    string2 = inetAddressArray[0].getHostAddress();
                } else {
                    string2 = (String)hashMap.get("ipNetworkNumber");
                }
            }
            catch (Exception exception) {
                log.error((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
                System.exit(14);
            }
        }
        return string2;
    }

    protected ArrayList<String> getFacilityIdList(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (repositoryController.isNode(string)) {
                arrayList.add(string);
            } else {
                arrayList.addAll(repositoryController.getExecTargetFacilityIdList(string));
            }
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected HashMap<String, ArrayList<String>> getMessageMap() {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        ArrayList<LogFilterInfo> arrayList = this.getSyslogngList();
        if (arrayList instanceof ArrayList) {
            for (LogFilterInfo logFilterInfo : arrayList) {
                Object[] objectArray = new Object[]{logFilterInfo.getMonitorId()};
                log.info((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.MonitorID", objectArray)));
                ArrayList<String> arrayList2 = this.getFacilityIdList(logFilterInfo.getFacilityId());
                for (String string : arrayList2) {
                    ArrayList<String> arrayList3 = hashMap.get(string);
                    if (!(arrayList3 instanceof ArrayList)) {
                        arrayList3 = new ArrayList();
                    }
                    arrayList3.add(logFilterInfo.getPattern());
                    hashMap.put(string, arrayList3);
                }
            }
        }
        return hashMap;
    }

    protected ArrayList<LogFilterInfo> getSyslogngList() {
        MonitorSyslogNGController monitorSyslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSyslogNGController.getFilterInfoList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected HashMap<String, ArrayList<String>> getFileMap() {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        ArrayList arrayList = this.getLogTransferIdList();
        if (arrayList instanceof ArrayList) {
            for (ArrayList arrayList2 : arrayList) {
                Object[] objectArray = new Object[]{(String)arrayList2.get(0)};
                log.info((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.TransferID", objectArray)));
                LogTransferInfo logTransferInfo = this.getLogTransfer((String)arrayList2.get(0));
                ArrayList<String> arrayList3 = this.getFacilityIdList(logTransferInfo.getFacilityId());
                for (String string : arrayList3) {
                    ArrayList<String> arrayList4 = hashMap.get(string);
                    if (!(arrayList4 instanceof ArrayList)) {
                        arrayList4 = new ArrayList();
                    }
                    for (LogTransferFileInfo logTransferFileInfo : logTransferInfo.getFileInfo()) {
                        arrayList4.add(logTransferFileInfo.getFilePath());
                    }
                    hashMap.put(string, arrayList4);
                }
            }
        }
        return hashMap;
    }

    protected LogTransferInfo getLogTransfer(String string) {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        LogTransferInfo logTransferInfo = null;
        try {
            logTransferInfo = logTransferController.getLogTransfer(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return logTransferInfo;
    }

    protected ArrayList getLogTransferIdList() {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        ArrayList arrayList = null;
        try {
            arrayList = logTransferController.getLogTransferList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("TestSyslog") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    static {
        attributeListTarget.add("ipProtocolNumber");
        attributeListTarget.add("ccNodeName");
        attributeListTarget.add("ipNetworkNumber");
        attributeListTarget.add("ccIpNetworkNumberV6");
        attributeListPlatform.add("ccPlatform");
    }

    public static class MyUserInfo
    implements UserInfo {
        protected BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        protected String passwd;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String string) {
            try {
                System.out.println("\n" + string);
                System.out.print("y/n > ");
                String string2 = this.reader.readLine();
                String string3 = string2.trim().toLowerCase();
                if (string3.equals("y")) {
                    return true;
                }
                return string3.equals("yes");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            try {
                System.out.println("\nEnter password");
                System.out.print("password > ");
                this.passwd = this.reader.readLine();
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }

        public void showMessage(String string) {
            System.out.print("message");
        }
    }
}

