/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.monitor.sql;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.monitor.ExportTestCaseMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportTestCaseMonitorSql
extends ExportTestCaseMonitor {
    private static Log log = LogFactory.getLog(ExportTestCaseMonitorSql.class);

    public void exportTestCase() {
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Sql.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getSqlList();
        if (arrayList2 instanceof ArrayList) {
            for (MonitorInfo monitorInfo : arrayList2) {
                if (monitorInfo.getMonitorType() != 1) continue;
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.MonitorID", objectArray)));
                arrayList.addAll(this.createTestCase(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/SQL_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.Sql.End")));
    }

    protected ArrayList getSqlList() {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSqlController.getSqlList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

