/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.logtransfer;

import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportTestCaseLogTransfer {
    private static Log log = LogFactory.getLog(ExportTestCaseLogTransfer.class);

    public void exportTestCase() {
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.LogTransfer.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getLogTransferIdList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.TransferID", objectArray)));
                LogTransferInfo logTransferInfo = this.getLogTransfer((String)arrayList3.get(0));
                arrayList.addAll(this.createTestCase(logTransferInfo));
            }
            Collections.sort(arrayList, new StringListComparator(2));
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Testcase.Output.Dir") + "/LOGTRANSFER_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.LogTransfer.End")));
    }

    public ArrayList<ArrayList<String>> createTestCase(LogTransferInfo logTransferInfo) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.getNodeList(logTransferInfo.getFacilityId()));
        for (String string : arrayList2) {
            Iterator iterator = logTransferInfo.getFileInfo().iterator();
            if (!iterator.hasNext()) continue;
            LogTransferFileInfo logTransferFileInfo = (LogTransferFileInfo)iterator.next();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(logTransferInfo.getTransferId());
            arrayList3.add(string);
            arrayList3.add(logTransferFileInfo.getFilePath());
            arrayList3.addAll(this.checkEvent(logTransferInfo, string, logTransferFileInfo));
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    protected ArrayList<String> checkEvent(LogTransferInfo logTransferInfo, String string, LogTransferFileInfo logTransferFileInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "-";
        String string3 = "-";
        String string4 = "-";
        String string5 = "-";
        if (logTransferInfo.getValid() == 1 && logTransferFileInfo.getValid() == 1) {
            string2 = "";
            string3 = "";
            string4 = "";
            string5 = "";
        }
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        return arrayList;
    }

    protected ArrayList<String> getNodeList(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (repositoryController.isNode(string)) {
                arrayList.add(string);
            } else {
                arrayList.addAll(repositoryController.getExecTargetFacilityIdList(string));
            }
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected LogTransferInfo getLogTransfer(String string) {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        LogTransferInfo logTransferInfo = null;
        try {
            logTransferInfo = logTransferController.getLogTransfer(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return logTransferInfo;
    }

    protected ArrayList getLogTransferIdList() {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        ArrayList arrayList = null;
        try {
            arrayList = logTransferController.getLogTransferList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("ExportTestCase") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

