/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import javax.swing.tree.DefaultMutableTreeNode;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibNode
extends DefaultMutableTreeNode {
    private String name;
    private ObjectIdentifierValue value;

    public MibNode(String name, ObjectIdentifierValue value) {
        super(name);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public ObjectIdentifierValue getValue() {
        return this.value;
    }

    public String getOid() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public MibValueSymbol getSymbol() {
        if (this.value == null) {
            return null;
        }
        return this.value.getSymbol();
    }

    public SnmpObjectType getSnmpObjectType() {
        MibValueSymbol symbol = this.getSymbol();
        if (symbol != null && symbol.getType() instanceof SnmpObjectType) {
            return (SnmpObjectType)symbol.getType();
        }
        return null;
    }

    public String getDescription() {
        if (this.value != null && this.value.getSymbol() != null) {
            return this.value.getSymbol().toString();
        }
        return "";
    }

    public String getToolTipText() {
        MibType type;
        if (this.value != null && this.value.getSymbol() != null && (type = this.value.getSymbol().getType()) instanceof SnmpType) {
            String str = ((SnmpType)type).getDescription();
            if (str.indexOf(46) > 0) {
                str = str.substring(0, str.indexOf(46) + 1);
            }
            if (str.length() > 150) {
                str = str.substring(0, 150) + "...";
            }
            return str.replaceAll("[ \t\r\n]+", " ");
        }
        return null;
    }
}

