/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.browser.BrowserFrame;
import net.percederberg.mibble.browser.MibTreeBuilder;

public class MibbleBrowser {
    private static final String COMMAND_HELP = "A graphical SNMP MIB file browser. This program comes with\nABSOLUTELY NO WARRANTY; for details see the LICENSE.txt file.\n\nSyntax: MibbleBrowser [<file(s) or URL(s)>]";
    private static final String INTERNAL_ERROR = "INTERNAL ERROR: An internal error has been found. Please report\n    this error to the maintainers (see the web site for\n    instructions). Be sure to include the version number, as\n    well as the text below:\n";
    private Properties buildInfo;
    private Preferences prefs;
    private MibLoader loader = new MibLoader();

    public static void main(String[] args) {
        new MibbleBrowser().start(args);
    }

    public MibbleBrowser() {
        this.prefs = Preferences.userNodeForPackage(this.getClass());
    }

    public void start(String[] args) {
        int i;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (!args[i2].startsWith("-")) continue;
            this.printHelp("No option '" + args[i2] + "' exist");
            System.exit(1);
        }
        this.buildInfo = new Properties();
        try {
            this.buildInfo.load(this.getClass().getResourceAsStream("build.properties"));
        }
        catch (IOException ignore) {
            this.buildInfo.setProperty("build.title", "Mibble");
        }
        try {
            String str = "com.apple.mrj.application.apple.menu.about.name";
            System.setProperty(str, this.buildInfo.getProperty("build.title"));
            str = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(str);
        }
        catch (Exception e) {
            this.printInternalError(e);
        }
        BrowserFrame frame = new BrowserFrame(this);
        frame.setVisible(true);
        frame.setBlocked(true);
        ArrayList list = this.getFilePrefs();
        for (i = 0; i < args.length; ++i) {
            list.add(args[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            frame.loadMib(list.get(i).toString());
        }
        if (list.size() <= 0) {
            frame.loadMib("RFC1213-MIB");
            frame.loadMib("HOST-RESOURCES-MIB");
        }
        frame.refreshTree();
        frame.setBlocked(false);
    }

    private void printHelp(String error) {
        System.err.println(COMMAND_HELP);
        System.err.println();
        if (error != null) {
            this.printError(error);
        }
    }

    private void printInternalError(Exception e) {
        System.err.println(INTERNAL_ERROR);
        e.printStackTrace();
    }

    private void printError(String message) {
        System.err.print("Error: ");
        System.err.println(message);
    }

    public Properties getBuildInfo() {
        return this.buildInfo;
    }

    public void loadMib(String src) throws IOException, MibLoaderException {
        MibTreeBuilder mb = MibTreeBuilder.getInstance();
        File file = new File(src);
        Mib mib = null;
        if (file.exists()) {
            if (this.loader.getMib(file) != null) {
                return;
            }
            if (!this.loader.hasDir(file.getParentFile())) {
                this.loader.removeAllDirs();
                this.loader.addDir(file.getParentFile());
            }
            mib = this.loader.load(file);
            this.addFilePref(file);
        } else {
            mib = this.loader.load(src);
        }
        mb.addMib(mib);
    }

    public void unloadMib(String name) {
        Mib mib = this.loader.getMib(name);
        if (mib != null) {
            this.removeFilePref(mib.getFile());
            try {
                this.loader.unload(name);
            }
            catch (MibLoaderException mibLoaderException) {
                // empty catch block
            }
            MibTreeBuilder.getInstance().unloadMib(name);
        }
    }

    public void unloadAllMibs() {
        this.removeFilePrefs();
        this.loader.unloadAll();
        MibTreeBuilder.getInstance().unloadAllMibs();
    }

    private void addFilePref(File file) {
        ArrayList list = this.getFilePrefs();
        if (!list.contains(file.getAbsolutePath())) {
            this.prefs.put("file" + list.size(), file.getAbsolutePath());
        }
    }

    private void removeFilePref(File file) {
        ArrayList list = this.getFilePrefs();
        this.removeFilePrefs();
        list.remove(file.getAbsolutePath());
        for (int i = 0; i < list.size(); ++i) {
            this.prefs.put("file" + i, list.get(i).toString());
        }
    }

    private ArrayList getFilePrefs() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            String str = this.prefs.get("file" + i, null);
            if (str == null) continue;
            list.add(str);
        }
        return list;
    }

    private void removeFilePrefs() {
        for (int i = 0; i < 1000; ++i) {
            this.prefs.remove("file" + i);
        }
    }
}

