/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.HashMap;
import net.percederberg.grammatica.parser.TokenNFA;
import net.percederberg.grammatica.parser.re.RegExpException;

class TokenRegExpParser {
    private String pattern;
    private boolean ignoreCase;
    private int pos;
    protected TokenNFA.State start = new TokenNFA.State();
    protected TokenNFA.State end = null;
    private int stateCount = 0;
    private int transitionCount = 0;
    private int epsilonCount = 0;

    public TokenRegExpParser(String pattern) throws RegExpException {
        this(pattern, false);
    }

    public TokenRegExpParser(String pattern, boolean ignoreCase) throws RegExpException {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
        this.pos = 0;
        this.end = this.parseExpr(this.start);
        if (this.pos < pattern.length()) {
            throw new RegExpException(1, this.pos, pattern);
        }
    }

    public String getDebugInfo() {
        if (this.stateCount == 0) {
            this.updateStats(this.start, new HashMap());
        }
        return this.stateCount + " states, " + this.transitionCount + " transitions, " + this.epsilonCount + " epsilons";
    }

    private void updateStats(TokenNFA.State state, HashMap visited) {
        if (!visited.containsKey(state)) {
            visited.put(state, null);
            ++this.stateCount;
            for (int i = 0; i < state.outgoing.length; ++i) {
                ++this.transitionCount;
                if (state.outgoing[i] instanceof TokenNFA.EpsilonTransition) {
                    ++this.epsilonCount;
                }
                this.updateStats(state.outgoing[i].state, visited);
            }
        }
    }

    private TokenNFA.State parseExpr(TokenNFA.State start) throws RegExpException {
        TokenNFA.State end = new TokenNFA.State();
        do {
            if (this.peekChar(0) == 124) {
                this.readChar('|');
            }
            TokenNFA.State subStart = new TokenNFA.State();
            TokenNFA.State subEnd = this.parseTerm(subStart);
            if (subStart.incoming.length == 0) {
                subStart.mergeInto(start);
            } else {
                start.addOut(new TokenNFA.EpsilonTransition(subStart));
            }
            if (subEnd.outgoing.length == 0 || !end.hasTransitions() && this.peekChar(0) != 124) {
                subEnd.mergeInto(end);
                continue;
            }
            subEnd.addOut(new TokenNFA.EpsilonTransition(end));
        } while (this.peekChar(0) == 124);
        return end;
    }

    private TokenNFA.State parseTerm(TokenNFA.State start) throws RegExpException {
        TokenNFA.State end = this.parseFact(start);
        while (true) {
            switch (this.peekChar(0)) {
                case -1: 
                case 41: 
                case 43: 
                case 63: 
                case 93: 
                case 123: 
                case 124: 
                case 125: {
                    return end;
                }
            }
            end = this.parseFact(end);
        }
    }

    private TokenNFA.State parseFact(TokenNFA.State start) throws RegExpException {
        TokenNFA.State placeholder = new TokenNFA.State();
        TokenNFA.State end = this.parseAtom(placeholder);
        switch (this.peekChar(0)) {
            case 42: 
            case 43: 
            case 63: 
            case 123: {
                end = this.parseAtomModifier(placeholder, end);
            }
        }
        if (placeholder.incoming.length > 0 && start.outgoing.length > 0) {
            start.addOut(new TokenNFA.EpsilonTransition(placeholder));
            return end;
        }
        placeholder.mergeInto(start);
        return end == placeholder ? start : end;
    }

    private TokenNFA.State parseAtom(TokenNFA.State start) throws RegExpException {
        switch (this.peekChar(0)) {
            case 46: {
                this.readChar('.');
                return start.addOut(new TokenNFA.DotTransition(new TokenNFA.State()));
            }
            case 40: {
                this.readChar('(');
                TokenNFA.State end = this.parseExpr(start);
                this.readChar(')');
                return end;
            }
            case 91: {
                this.readChar('[');
                TokenNFA.State end = this.parseCharSet(start);
                this.readChar(']');
                return end;
            }
            case -1: 
            case 41: 
            case 42: 
            case 43: 
            case 63: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                throw new RegExpException(1, this.pos, this.pattern);
            }
        }
        return this.parseChar(start);
    }

    private TokenNFA.State parseAtomModifier(TokenNFA.State start, TokenNFA.State end) throws RegExpException {
        int min = 0;
        int max = -1;
        int firstPos = this.pos;
        switch (this.readChar()) {
            case '?': {
                min = 0;
                max = 1;
                break;
            }
            case '*': {
                min = 0;
                max = -1;
                break;
            }
            case '+': {
                min = 1;
                max = -1;
                break;
            }
            case '{': {
                max = min = this.readNumber();
                if (this.peekChar(0) == 44) {
                    this.readChar(',');
                    max = -1;
                    if (this.peekChar(0) != 125) {
                        max = this.readNumber();
                    }
                }
                this.readChar('}');
                if (max != 0 && (max <= 0 || min <= max)) break;
                throw new RegExpException(5, firstPos, this.pattern);
            }
            default: {
                throw new RegExpException(1, this.pos - 1, this.pattern);
            }
        }
        if (this.peekChar(0) == 63) {
            throw new RegExpException(3, this.pos, this.pattern);
        }
        if (this.peekChar(0) == 43) {
            throw new RegExpException(3, this.pos, this.pattern);
        }
        if (min == 0 && max == 1) {
            return start.addOut(new TokenNFA.EpsilonTransition(end));
        }
        if (min == 0 && max == -1) {
            if (end.outgoing.length == 0) {
                end.mergeInto(start);
            } else {
                end.addOut(new TokenNFA.EpsilonTransition(start));
            }
            return start;
        }
        if (min == 1 && max == -1) {
            if (start.outgoing.length == 1 && end.outgoing.length == 0 && end.incoming.length == 1 && start.outgoing[0] == end.incoming[0]) {
                end.addOut(start.outgoing[0].copy(end));
            } else {
                end.addOut(new TokenNFA.EpsilonTransition(start));
            }
            return end;
        }
        throw new RegExpException(5, firstPos, this.pattern);
    }

    private TokenNFA.State parseCharSet(TokenNFA.State start) throws RegExpException {
        TokenNFA.CharRangeTransition range;
        TokenNFA.State end = new TokenNFA.State();
        if (this.peekChar(0) == 94) {
            this.readChar('^');
            range = new TokenNFA.CharRangeTransition(true, this.ignoreCase, end);
        } else {
            range = new TokenNFA.CharRangeTransition(false, this.ignoreCase, end);
        }
        start.addOut(range);
        block4: while (this.peekChar(0) > 0) {
            char min = (char)this.peekChar(0);
            switch (min) {
                case ']': {
                    return end;
                }
                case '\\': {
                    range.addCharacter(this.readEscapeChar());
                    continue block4;
                }
            }
            this.readChar(min);
            if (this.peekChar(0) == 45 && this.peekChar(1) > 0 && this.peekChar(1) != 93) {
                this.readChar('-');
                char max = this.readChar();
                range.addRange(min, max);
                continue;
            }
            range.addCharacter(min);
        }
        return end;
    }

    private TokenNFA.State parseChar(TokenNFA.State start) throws RegExpException {
        switch (this.peekChar(0)) {
            case 92: {
                return this.parseEscapeChar(start);
            }
            case 36: 
            case 94: {
                throw new RegExpException(3, this.pos, this.pattern);
            }
        }
        return start.addOut(this.readChar(), this.ignoreCase, new TokenNFA.State());
    }

    private TokenNFA.State parseEscapeChar(TokenNFA.State start) throws RegExpException {
        TokenNFA.State end = new TokenNFA.State();
        if (this.peekChar(0) == 92 && this.peekChar(1) > 0) {
            switch ((char)this.peekChar(1)) {
                case 'd': {
                    this.readChar();
                    this.readChar();
                    return start.addOut(new TokenNFA.DigitTransition(end));
                }
                case 'D': {
                    this.readChar();
                    this.readChar();
                    return start.addOut(new TokenNFA.NonDigitTransition(end));
                }
                case 's': {
                    this.readChar();
                    this.readChar();
                    return start.addOut(new TokenNFA.WhitespaceTransition(end));
                }
                case 'S': {
                    this.readChar();
                    this.readChar();
                    return start.addOut(new TokenNFA.NonWhitespaceTransition(end));
                }
                case 'w': {
                    this.readChar();
                    this.readChar();
                    return start.addOut(new TokenNFA.WordTransition(end));
                }
                case 'W': {
                    this.readChar();
                    this.readChar();
                    return start.addOut(new TokenNFA.NonWordTransition(end));
                }
            }
        }
        return start.addOut(this.readEscapeChar(), this.ignoreCase, end);
    }

    private char readEscapeChar() throws RegExpException {
        this.readChar('\\');
        char c = this.readChar();
        switch (c) {
            case '0': {
                c = this.readChar();
                if (c < '0' || c > '3') {
                    throw new RegExpException(4, this.pos - 3, this.pattern);
                }
                String str = String.valueOf(c);
                c = (char)this.peekChar(0);
                if ('0' <= c && c <= '7') {
                    str = str + String.valueOf(this.readChar());
                    c = (char)this.peekChar(0);
                    if ('0' <= c && c <= '7') {
                        str = str + String.valueOf(this.readChar());
                    }
                }
                try {
                    return (char)Integer.parseInt(str, 8);
                }
                catch (NumberFormatException e) {
                    throw new RegExpException(4, this.pos - str.length() - 2, this.pattern);
                }
            }
            case 'x': {
                String str = String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    return (char)Integer.parseInt(str, 16);
                }
                catch (NumberFormatException e) {
                    throw new RegExpException(4, this.pos - str.length() - 2, this.pattern);
                }
            }
            case 'u': {
                String str = String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    return (char)Integer.parseInt(str, 16);
                }
                catch (NumberFormatException e) {
                    throw new RegExpException(4, this.pos - str.length() - 2, this.pattern);
                }
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
        }
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
            throw new RegExpException(4, this.pos - 2, this.pattern);
        }
        return c;
    }

    private int readNumber() throws RegExpException {
        StringBuffer buf = new StringBuffer();
        int c = this.peekChar(0);
        while (48 <= c && c <= 57) {
            buf.append(this.readChar());
            c = this.peekChar(0);
        }
        if (buf.length() <= 0) {
            throw new RegExpException(1, this.pos, this.pattern);
        }
        return Integer.parseInt(buf.toString());
    }

    private char readChar() throws RegExpException {
        int c = this.peekChar(0);
        if (c < 0) {
            throw new RegExpException(2, this.pos, this.pattern);
        }
        ++this.pos;
        return (char)c;
    }

    private char readChar(char c) throws RegExpException {
        if (c != this.readChar()) {
            throw new RegExpException(1, this.pos - 1, this.pattern);
        }
        return c;
    }

    private int peekChar(int count) {
        if (this.pos + count < this.pattern.length()) {
            return this.pattern.charAt(this.pos + count);
        }
        return -1;
    }
}

