/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.check.conf;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMonitor {
    private ArrayList idList = null;
    private int nodeTotalCount = 0;
    private int notifyTotalCount = 0;

    public int getListCount() {
        if (this.idList instanceof ArrayList) {
            return this.idList.size();
        }
        return 0;
    }

    public int getNodeCount(MonitorInfo monitorInfo) {
        int n = 0;
        if (monitorInfo.getMonitorBlock() == 0) {
            RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
            try {
                ArrayList arrayList = repositoryController.getNodeList(monitorInfo.getFacilityId(), 0);
                n = arrayList.size();
            }
            catch (RemoteException remoteException) {
            }
            catch (FinderException finderException) {
            }
            catch (NamingException namingException) {}
        } else {
            n = 1;
        }
        return n;
    }

    public int getNotifyCount(MonitorInfo monitorInfo) {
        int n = 0;
        if (monitorInfo.getNotifyId() != null) {
            Collection collection = monitorInfo.getNotifyId();
            n = collection.size();
        }
        return n;
    }

    public static ArrayList<String> createOutputHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("MonitorType");
        arrayList.add("MonitorCount");
        arrayList.add("TotalNodeCount");
        arrayList.add("ToralNotifyCount");
        return arrayList;
    }

    public ArrayList<String> createOutput(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(String.valueOf(this.getListCount()));
        arrayList.add(String.valueOf(this.getNodeTotalCount()));
        arrayList.add(String.valueOf(this.getNotifyTotalCount()));
        return arrayList;
    }

    public ArrayList getIdList() {
        return this.idList;
    }

    public void setIdList(ArrayList arrayList) {
        this.idList = arrayList;
    }

    public int getNodeTotalCount() {
        return this.nodeTotalCount;
    }

    public void setNodeTotalCount(int n) {
        this.nodeTotalCount = n;
    }

    public void addNodeTotalCount(int n) {
        this.nodeTotalCount += n;
    }

    public int getNotifyTotalCount() {
        return this.notifyTotalCount;
    }

    public void setNotifyTotalCount(int n) {
        this.notifyTotalCount = n;
    }

    public void addNotifyTotalCount(int n) {
        this.notifyTotalCount += n;
    }
}

