/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.type.Constraint;

public class SnmpTextualConvention
extends SnmpType
implements MibContext {
    private String displayHint;
    private SnmpStatus status;
    private String reference;
    private MibType syntax;

    public static SnmpTextualConvention findReference(MibType type) {
        if (type instanceof SnmpObjectType) {
            type = ((SnmpObjectType)type).getSyntax();
        }
        if (type instanceof SnmpTextualConvention) {
            return (SnmpTextualConvention)type;
        }
        MibTypeSymbol sym = type.getReferenceSymbol();
        return sym == null ? null : SnmpTextualConvention.findReference(sym.getType());
    }

    public SnmpTextualConvention(String displayHint, SnmpStatus status, String description, String reference, MibType syntax) {
        super("TEXTUAL-CONVENTION", description);
        this.displayHint = displayHint;
        this.status = status;
        this.reference = reference;
        this.syntax = syntax;
    }

    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        this.syntax = this.syntax.initialize(symbol, log);
        return this;
    }

    public MibType createReference() throws UnsupportedOperationException {
        return this.syntax.createReference();
    }

    public MibType createReference(Constraint constraint) throws UnsupportedOperationException {
        return this.syntax.createReference(constraint);
    }

    public MibType createReference(ArrayList values) throws UnsupportedOperationException {
        return this.syntax.createReference(values);
    }

    public boolean isCompatible(MibValue value) {
        return false;
    }

    public String getDisplayHint() {
        return this.displayHint;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibSymbol findSymbol(String name, boolean expanded) {
        if (this.syntax instanceof MibContext) {
            return ((MibContext)((Object)this.syntax)).findSymbol(name, expanded);
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(" (");
        if (this.displayHint != null) {
            buffer.append("\n  Display-Hint: ");
            buffer.append(this.displayHint);
        }
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.getDescription("               "));
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        buffer.append("\n  Syntax: ");
        buffer.append(this.syntax);
        buffer.append("\n)");
        return buffer.toString();
    }
}

