/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

public class TokenPattern {
    public static final int STRING_TYPE = 1;
    public static final int REGEXP_TYPE = 2;
    private int id;
    private String name;
    private int type;
    private String pattern;
    private boolean error = false;
    private String errorMessage = null;
    private boolean ignore = false;
    private String ignoreMessage = null;
    private String debugInfo = null;

    public TokenPattern(int id, String name, int type, String pattern) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.pattern = pattern;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getIgnoreMessage() {
        return this.ignoreMessage;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public void setError() {
        this.setError("unrecognized token found");
    }

    public void setError(String message) {
        this.error = true;
        this.errorMessage = message;
    }

    public void setIgnore() {
        this.setIgnore(null);
    }

    public void setIgnore(String message) {
        this.ignore = true;
        this.ignoreMessage = message;
    }

    public void setDebugInfo(String info) {
        this.debugInfo = info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append(" (");
        buffer.append(this.id);
        buffer.append(") = ");
        if (this.type == 1) {
            buffer.append("\"");
            buffer.append(this.pattern);
            buffer.append("\"");
        } else if (this.type == 2) {
            buffer.append("<<");
            buffer.append(this.pattern);
            buffer.append(">>");
        }
        if (this.error) {
            buffer.append(" ERROR: \"");
            buffer.append(this.errorMessage);
            buffer.append("\"");
        }
        if (this.ignore) {
            buffer.append(" IGNORE");
            if (this.ignoreMessage != null) {
                buffer.append(": \"");
                buffer.append(this.ignoreMessage);
                buffer.append("\"");
            }
        }
        if (this.debugInfo != null) {
            buffer.append("\n  ");
            buffer.append(this.debugInfo);
        }
        return buffer.toString();
    }

    public String toShortString() {
        StringBuffer buffer = new StringBuffer();
        int newline = this.pattern.indexOf(10);
        if (this.type == 1) {
            buffer.append("\"");
            if (newline >= 0) {
                if (newline > 0 && this.pattern.charAt(newline - 1) == '\r') {
                    --newline;
                }
                buffer.append(this.pattern.substring(0, newline));
                buffer.append("(...)");
            } else {
                buffer.append(this.pattern);
            }
            buffer.append("\"");
        } else {
            buffer.append("<");
            buffer.append(this.name);
            buffer.append(">");
        }
        return buffer.toString();
    }
}

