/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.calendar;

import com.clustercontrol.bean.YesNoConstant;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.util.StringListComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDate {
    private ArrayList calendar = null;
    private ArrayList rule = null;
    private ArrayList exception = null;
    private Date from = null;
    private Date to = null;
    private static Log log = LogFactory.getLog(ExportDate.class);

    public ExportDate(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        this.calendar = arrayList;
        this.rule = arrayList2;
        this.exception = arrayList3;
        this.from = (Date)arrayList.get(2);
        this.to = (Date)arrayList.get(3);
    }

    public ArrayList<String> exportDate(Date date) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date2 = calendar.getTime();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date date3 = calendar.getTime();
        if (this.from.before(date2) && this.to.after(date2) || this.from.before(date3) && this.to.after(date3)) {
            arrayList.addAll(this.isScheduleByException(date));
            arrayList.addAll(this.isScheduleByRule(date));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        return arrayList;
    }

    protected ArrayList<String> isScheduleByException(Date date) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date2 = calendar.getTime();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date date3 = calendar.getTime();
        for (ArrayList arrayList2 : this.exception) {
            Date date4 = (Date)arrayList2.get(1);
            Date date5 = (Date)arrayList2.get(2);
            if (!(date4.after(date2) && date5.before(date3) || date4.before(date2) && date5.after(date2)) && (!date4.before(date3) || !date5.after(date3))) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[E]");
            Boolean bl = (Boolean)arrayList2.get(0);
            if (bl.booleanValue()) {
                stringBuilder.append("[" + YesNoConstant.STRING_YES + "]");
            } else {
                stringBuilder.append("[" + YesNoConstant.STRING_NO + "]");
            }
            stringBuilder.append(DateFormat.getDateTimeInstance().format(date4));
            stringBuilder.append("-");
            stringBuilder.append(DateFormat.getDateTimeInstance().format(date5));
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    protected ArrayList<String> isScheduleByRule(Date date) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Integer n = calendar.get(7);
        for (ArrayList arrayList2 : this.rule) {
            if (!n.equals((Integer)arrayList2.get(0))) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[R]");
            if (arrayList2.get(1) instanceof Date) {
                stringBuilder.append(simpleDateFormat.format((Date)arrayList2.get(1)));
            } else {
                stringBuilder.append("");
            }
            stringBuilder.append("-");
            if (arrayList2.get(2) instanceof Date) {
                stringBuilder.append(simpleDateFormat.format((Date)arrayList2.get(2)));
            } else {
                stringBuilder.append("");
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

