/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.jmx;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class OutputMBeanAttribute {
    private static Log log = LogFactory.getLog(OutputMBeanAttribute.class);
    public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    public static final String OBJECT_NAME = "jboss.jca:name=HinemosDS,service=ManagedConnectionPool";

    public void check(String string, String string2) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(DateFormat.getDateTimeInstance().format(new Date()));
        RMIAdaptor rMIAdaptor = EjbConnectionManager.getConnectionManager().getRMIAdaptor();
        try {
            ObjectName objectName = new ObjectName(string);
            log.info((Object)("ObjectName = " + string));
            MBeanInfo mBeanInfo = rMIAdaptor.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
                String string3 = mBeanAttributeInfo.getName();
                log.info((Object)("AttributeName = " + string3));
                arrayList2.add(string3);
                try {
                    Object object = rMIAdaptor.getAttribute(objectName, string3);
                    if (object != null) {
                        arrayList2.add(object.toString());
                        continue;
                    }
                    arrayList2.add("");
                }
                catch (Exception exception) {
                    arrayList2.add("");
                    log.debug((Object)"Error : getAttribute", (Throwable)exception);
                }
            }
            arrayList.add(arrayList2);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            WriteCsvFile.writeCsvFile(Config.getConfig("JMX.Dir") + "/" + string2 + "_" + simpleDateFormat.format(new Date()) + ".csv", arrayList, true);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
        }
    }
}

