/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.bean.PortRunCountConstant;
import com.clustercontrol.bean.PortRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.port.bean.MonitorPortInfo;
import com.clustercontrol.port.ejb.session.MonitorPortController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorNumeric;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorPort
extends ExportMonitorNumeric {
    private static Log log = LogFactory.getLog(ExportMonitorPort.class);

    public ExportMonitorPort() {
        super(2);
    }

    public void exportPort() {
        log.info((Object)Messages.getMsg("Port.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPortList();
        if (arrayList2 instanceof ArrayList) {
            for (Cloneable cloneable : arrayList2) {
                Object[] objectArray = new Object[]{(String)((ArrayList)cloneable).get(0)};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                MonitorInfo monitorInfo = this.getPort((String)((ArrayList)cloneable).get(0));
                arrayList.add(this.createCsvFormat(monitorInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Cloneable cloneable;
            cloneable = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)cloneable).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/PORT" + (String)object + ".csv", arrayList);
        log.info((Object)Messages.getMsg("Port.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitorPortInfo monitorPortInfo = (MonitorPortInfo)monitorInfo.getCheckInfo();
        if (monitorPortInfo == null) {
            monitorPortInfo = new MonitorPortInfo();
        }
        if (monitorPortInfo.getServiceId() == null || monitorPortInfo.getServiceId().equals("001")) {
            arrayList.add(com.clustercontrol.util.Messages.getString((String)"tcp.connect.only"));
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getPortNo() != null) {
            arrayList.add(monitorPortInfo.getPortNo().toString());
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getRunCount() != null) {
            arrayList.add(PortRunCountConstant.typeToString((int)monitorPortInfo.getRunCount()));
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getRunInterval() != null) {
            arrayList.add(PortRunIntervalConstant.typeToString((int)monitorPortInfo.getRunInterval()));
        } else {
            arrayList.add("");
        }
        if (monitorPortInfo.getTimeout() != null) {
            arrayList.add(monitorPortInfo.getTimeout().toString());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected MonitorInfo getPort(String string) {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        MonitorInfo monitorInfo = null;
        try {
            monitorInfo = monitorPortController.getPort(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return monitorInfo;
    }

    protected ArrayList getPortList() {
        MonitorPortController monitorPortController = EjbConnectionManager.getConnectionManager().getMonitorPortController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPortController.getPortList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

