/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.naming.NamingException;
import jp.co.intellilink.hinemos.export.history.ExportCollectiveRun;
import jp.co.intellilink.hinemos.export.history.ExportEvent;
import jp.co.intellilink.hinemos.export.history.ExportJob;
import jp.co.intellilink.hinemos.export.history.ExportPerformance;
import jp.co.intellilink.hinemos.export.history.ExportStatus;
import jp.co.intellilink.hinemos.util.LoginManager;
import jp.co.intellilink.hinemos.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportHistory {
    private static String mode = "all";
    private static Date startDate = null;
    private static Log log = LogFactory.getLog(ExportHistory.class);

    public static void main(String[] stringArray) {
        Object object;
        log.info((Object)(Messages.getMsg("ExportTool.Exec") + " : " + Arrays.toString(stringArray)));
        if (stringArray.length > 2) {
            log.error((Object)Messages.getMsg("ArgsInvalid"));
            System.exit(11);
        }
        if (stringArray.length == 0 || stringArray[0].equals("")) {
            mode = "all";
        } else if (stringArray.length >= 1) {
            mode = stringArray[0];
        }
        if (stringArray.length >= 2) {
            try {
                startDate = DateFormat.getDateTimeInstance().parse(stringArray[1]);
            }
            catch (ParseException parseException) {
                try {
                    startDate = DateFormat.getDateInstance().parse(stringArray[1]);
                }
                catch (ParseException parseException2) {
                    try {
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(5, Integer.parseInt(stringArray[1]));
                        startDate = calendar.getTime();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (startDate == null) {
            startDate = new Date();
        }
        if (mode.equalsIgnoreCase("event") || mode.equalsIgnoreCase("all")) {
            object = new ExportEvent();
            ((ExportEvent)object).export(startDate);
        }
        if (mode.equalsIgnoreCase("status") || mode.equalsIgnoreCase("all")) {
            object = new ExportStatus();
            ((ExportStatus)object).export();
        }
        if (mode.equalsIgnoreCase("perf") || mode.equalsIgnoreCase("all")) {
            object = new ExportPerformance();
            ((ExportPerformance)object).export(startDate);
        }
        if (mode.equalsIgnoreCase("job") || mode.equalsIgnoreCase("all")) {
            object = new ExportJob();
            ((ExportJob)object).export(startDate);
        }
        if (mode.equalsIgnoreCase("crun") || mode.equalsIgnoreCase("all")) {
            object = new ExportCollectiveRun();
            ((ExportCollectiveRun)object).export(startDate);
        }
        try {
            LoginManager.getContextManager().logout();
        }
        catch (NamingException namingException) {
            log.warn((Object)Messages.getMsg("DisconnectManagerFailed"), (Throwable)namingException);
        }
        log.info((Object)Messages.getMsg("ExportTool.Exit"));
        System.exit(0);
    }
}

