<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns="http://purl.org/rss/1.0/"
                              xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                              xmlns:content="http://purl.org/rss/1.0/modules/content/"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/"
                              exclude-result-prefixes="hml dcterms sdf xh">

<xsl:param name="uri" select="'http://test.com/'"/>

<!-- sdf:document into basic structure -->
<xsl:template match="/sdf:document">
    <rdf:RDF>
        <channel rdf:about="$uri">
            <title>
                <xsl:value-of select="./sdf:meta/dc:title"/>
            </title>
            <description>
                <xsl:value-of select="./sdf:body/xh:p[1]"/>
            </description>
            <link>
                <xsl:value-of select="$uri"/>
            </link>
            <items>
                <rdf:Seq>
                    <xsl:apply-templates select="./sdf:body/sdf:section" mode="inner"/>
                </rdf:Seq>
            </items>
        </channel>
        <xsl:apply-templates select="./sdf:body/sdf:section" mode="outer"/>
    </rdf:RDF>
</xsl:template>


<xsl:template match="sdf:section" mode="inner">
    <rdf:li rdf:resource="{./sdf:meta/xh:link[@rel = 'permanent']/@href}"/>
</xsl:template>

<xsl:template match="sdf:section" mode="outer">
    <item rdf:about="{./sdf:meta/xh:link[@rel = 'permanent']/@href}">
        <title><xsl:value-of select="./sdf:meta/dc:title"/></title>
        <description><xsl:value-of select="./sdf:body/descendant::xh:p[text()][1]"/></description>
        <content:encoded>
            <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                <xsl:apply-templates select="./sdf:body/node()" mode="toEncoded"/>
            <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
        </content:encoded>
        <link><xsl:value-of select="./sdf:meta/xh:link[@rel = 'permanent']/@href"/></link>
        <dc:date><xsl:value-of select="./sdf:meta/dcterms:modified"/></dc:date>
    </item>
</xsl:template>

<xsl:template match="*" mode="toEncoded">
    <xsl:element name="{local-name()}">
        <xsl:apply-templates select="@*" mode="toEncoded"/>
        <xsl:apply-templates mode="toEncoded"/>
    </xsl:element>
</xsl:template>

<xsl:template match="@*" mode="toEncoded">
    <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>