<?php
class Xnm_DataManager {
    private static $dataControllerInstance = NULL;

    public static function initialize($type, $timezoneOffset) {
        if (! self::$dataControllerInstance) {
            if ($type == "FileSystem") {
                self::$dataControllerInstance = new Xnm_DataControllerFileSystem($timezoneOffset);
            } elseif ($type == "FileSystemWithRNoteSupport") {
                self::$dataControllerInstance = new Xnm_DataControllerFileSystemRNote($timezoneOffset);
            } else {
                throw new Exception("Data Strage Not Registered.");
            }
        } else {
            throw new Exception("Data Storage type have aleady selected.");
        }
        
    }


    public static function getInstance() {
        if (self::$dataControllerInstance) {
            return self::$dataControllerInstance;
        } else {
            throw new Exception("Not initialized yet.");
        }
    }


    public static function loadNote($id) {
        return self::$dataControllerInstance->readNote($id);
    }


    public static function parseW3cdtf($dateStr) {
        return Hml_Util::parseW3cdtf($dateStr);
    }
}
?>