<?php
class Xnm_DataControllerFileSystemRNote extends Xnm_DataControllerFileSystem {

    protected function getItratorToBuildIndex() {
        return new Xnm_ItratorToBuildIndexFileSystemRNote($this->noteList); 
    }


    public function loadData($internalId) {
        $targetDom = parent::loadData($internalId);
        $targetXp = new DomXpath($targetDom);
        $targetXp->registerNamespace("rnote", "http://rinn.e-site.jp/rnote/");
        if ($targetXp->query("/rnote:rNote")->item(0)) {
            $domXsl = new DomDocument();
            $domXsl->load("RNoteToXnm.xsl");
            $xsltp = new XsltProcessor();
            $xsltp->importStyleSheet($domXsl);
            $targetDom = $xsltp->transformToDoc($targetDom);
        }
        return $targetDom;
    }
}
?>