<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>


<xsl:template match="/nidx:index">
    <xsl:for-each select="/nidx:index/nidx:year[@num = $nidx:year]/nidx:month[@num = $nidx:month]/nidx:day[@num = $nidx:day]/nidx:note[@num = concat($nidx:hour, $nidx:minute, $nidx:second)]">
        <xsl:variable name="nidx:current_note" select="php:function('Xnm_DataManager::loadNote', string(./@id))"/>
        <sdf:document xml:lang="ja">
            <sdf:meta>
                <dc:title>
                    <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
                    <xsl:text>::</xsl:text>
                    <xsl:value-of select="$nidx:year"/>
                    <xsl:text>-</xsl:text>
                    <xsl:value-of select="$nidx:month"/>
                    <xsl:text>-</xsl:text>
                    <xsl:value-of select="$nidx:day"/>
                    <xsl:text>::</xsl:text>
                    <xsl:copy-of select="./dc:title/node()"/>
                </dc:title>
                <xsl:call-template name="nidx:copy_latest_modified">
                    <xsl:with-param name="nidx:targets_dom" select="."/>
                </xsl:call-template>
                <xsl:call-template name="nidx:copy_oldest_created">
                    <xsl:with-param name="nidx:targets_dom" select="."/>
                </xsl:call-template>

                <link rel="up" href="../{parent::nidx:day/@num}" title="{$nts:settings/nts:value[@name = 'siteName']}::{ancestor::nidx:year/@num}-{ancestor::nidx:month/@num}-{parent::nidx:day/@num}"/>

                <xsl:variable name="prev_page" select="/descendant::nidx:note[@id &lt; current()/@id][nt:category/nt:li = $nidx:category][last()]"/>
                <xsl:if test="$prev_page">
                    <link rel="prev" href="{$nidx:rootPath}/{$prev_page[1]/ancestor::nidx:year/@num}/{$prev_page[1]/ancestor::nidx:month/@num}/{$prev_page[1]/ancestor::nidx:day/@num}/{$prev_page[1]/@num}" title="{$nts:settings/nts:value[@name = 'SiteName']}::{$prev_page[1]/ancestor::nidx:year/@num}-{$prev_page[1]/ancestor::nidx:month/@num}-{$prev_page[1]/ancestor::nidx:day/@num}::{$prev_page[1]/dc:title}"/>
                </xsl:if>
                <xsl:variable name="next_page" select="/descendant::nidx:note[@id &gt; current()/@id][nt:category/nt:li = $nidx:category][1]"/>
                <xsl:if test="$next_page">
                    <link rel="next" href="{$nidx:rootPath}/{$next_page[1]/ancestor::nidx:year/@num}/{$next_page[1]/ancestor::nidx:month/@num}/{$next_page[1]/ancestor::nidx:day/@num}/{$next_page[1]/@num}" title="{$nts:settings/nts:value[@name = 'SiteName']}::{$next_page[1]/ancestor::nidx:year/@num}-{$next_page[1]/ancestor::nidx:month/@num}-{$next_page[1]/ancestor::nidx:day/@num}::{$next_page[1]/dc:title}"/>
                </xsl:if>
            </sdf:meta>
            <sdf:body>
                <xsl:copy-of select="$nidx:current_note/nt:note/nt:body/node()"/>
                <xsl:call-template name="showComments"/>
                <xsl:call-template name="showTrackbacks"/>
                <xsl:call-template name="showCommentForm"/>
            </sdf:body>
        </sdf:document>
    </xsl:for-each>
</xsl:template>

<xsl:template name="showComments">
    <sdf:section xml:id="comments">
        <sdf:meta>
            <dc:title>Comments</dc:title>
        </sdf:meta>
        <sdf:body>
            <xsl:choose>
                <xsl:when test="./nt:comments">
                    <xsl:for-each select="./nt:comments/nt:comment">
                        <dl>
                            <dt>Name</dt>
                            <dd>
                                <xsl:choose>
                                    <xsl:when test="./nt:identifier/text()">
                                        <a href="{./nt:identifier}">
                                            <xsl:choose>
                                                <xsl:when test="./nt:name/text()">
                                                    <xsl:value-of select="./nt:name"/>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>ANONYMOUS</xsl:text>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </a>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="./nt:name/text()">
                                                <xsl:value-of select="./nt:name"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>ANONYMOUS</xsl:text>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </dd>
                            <dt>Datetime</dt>
                            <dd>
                                <xsl:value-of select="./nt:datetime"/>
                            </dd>
                            <dt>Message</dt>
                            <dd>
                                <xsl:value-of select="./nt:message"/>
                            </dd>
                        </dl>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <ul>
                        <li>None</li>
                    </ul>
                </xsl:otherwise>
            </xsl:choose>
        </sdf:body>
    </sdf:section>
</xsl:template>

<xsl:template name="showCommentForm">
    <sdf:section>
        <sdf:meta>
            <dc:title>Post a comment</dc:title>
        </sdf:meta>
        <sdf:body>
            <form action="{$nidx:rootPath}/{ancestor::nidx:year/@num}/{ancestor::nidx:month/@num}/{ancestor::nidx:day/@num}/{@num}" method="POST">
                <dl>
                    <dt>Name (optional)</dt>
                    <dd>
                        <input type="text" size="35" name="name"/>
                    </dd>
                    <dt>Mail address or URI (optional)</dt>
                    <dd>
                        <input type="text" size="35" name="identifier"/>
                    </dd>
                    <dt>Message (required)</dt>
                    <dd>
                        <textarea rows="10" cols="50" name="message"/>
                    </dd>
                    <dt>Submit</dt>
                    <dd>
                        <input type="hidden" name="action" value="comment"/>
                        <input type="hidden" name="target" value="{./@id}"/>
                        <input type="submit" value="Post"/>
                    </dd>
                </dl>
            </form>
        </sdf:body>
    </sdf:section>
</xsl:template>

<xsl:template name="showTrackbacks">
    <sdf:section xml:id="trackbacks">
        <sdf:meta>
            <dc:title>Trackbacks</dc:title>
        </sdf:meta>
        <sdf:body>
            <dl>
                <dt>Trackback Ping URI</dt>
                <dd>
                    <xsl:value-of select="$nidx:webPrefix"/>
                    <xsl:value-of select="$nidx:rootPath"/>
                    <xsl:value-of select="concat('/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num, '.trackback')"/>
                </dd>
            </dl>
            <xsl:choose>
                <xsl:when test="./nt:referredBy">
                    <xsl:for-each select="./nt:referredBy/nt:Trackback">
                        <dl>
                            <dt>Title</dt>
                            <dd>
                                <a href="{./@uri}">
                                    <xsl:choose>
                                        <xsl:when test="./nt:title/text()">
                                            <xsl:value-of select="./nt:title"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="./@uri"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </a>
                            </dd>
                            <dt>Datetime</dt>
                            <dd>
                                <xsl:value-of select="./nt:datetime"/>
                            </dd>
                            <xsl:if test="./nt:excerpt/text()">
                                <dt>Excerpt</dt>
                                <dd>
                                    <xsl:value-of select="./nt:excerpt"/>
                                </dd>
                            </xsl:if>
                            <xsl:if test="./nt:blogName/text()">
                                <dt>From</dt>
                                <dd>
                                    <xsl:value-of select="./nt:blogName"/>
                                </dd>
                            </xsl:if>
                        </dl>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <ul>
                        <li>None</li>
                    </ul>
                </xsl:otherwise>
            </xsl:choose>
        </sdf:body>
    </sdf:section>
</xsl:template>

</xsl:stylesheet>