<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
                <xsl:if test="not($nidx:category = 'ALL')">
                    <xsl:text>::</xsl:text>
                    <xsl:call-template name="getCategoryName">
                        <xsl:with-param name="of" select="$nidx:category"/>
                    </xsl:call-template>
                </xsl:if>
            </dc:title>

            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="//nidx:note"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="///nidx:note"/>
            </xsl:call-template>

            <xsl:if test="not($nidx:category = 'ALL')">
                <link rel="up" href="{$nidx:rootPath}"/>
            </xsl:if>
        </sdf:meta>
        <sdf:body>
            <sdf:section>
                <sdf:meta>
                    <dc:title>時系列一覧</dc:title>
                </sdf:meta>
                <sdf:body>
                    <ul>
                        <li><a href="{$nidx:rootPath}/latest">最新分</a></li>
                    </ul>
                    <xsl:call-template name="listYears">
                        <xsl:with-param name="target" select="/nidx:index/nidx:year"/>
                        <xsl:with-param name="layer" select="2"/>
                        <xsl:with-param name="category" select="$nidx:category"/>
                    </xsl:call-template>
                </sdf:body>
            </sdf:section>
            <sdf:section>
                <sdf:meta>
                    <dc:title>カテゴリ一覧</dc:title>
                </sdf:meta>
                <sdf:body>
                    <xsl:call-template name="listCategories">
                        <xsl:with-param name="layer" select="2"/>
                    </xsl:call-template>
                </sdf:body>
            </sdf:section>
        </sdf:body>
    </sdf:document>
</xsl:template>


</xsl:stylesheet>