<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:variable name="nodeSetShortCut" select="/nidx:index/nidx:year[@num = $nidx:year]/nidx:month[@num = $nidx:month]/nidx:day[@num = $nidx:day]"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
                <xsl:text>::</xsl:text>
                <xsl:value-of select="$nidx:year"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="$nidx:month"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="$nidx:day"/>
                <xsl:if test="not($nidx:category = 'ALL')">
                    <xsl:text>::</xsl:text>
                    <xsl:call-template name="getCategoryName">
                        <xsl:with-param name="of" select="$nidx:category"/>
                    </xsl:call-template>
                </xsl:if>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="$nodeSetShortCut/nidx:note[nt:category/nt:li = $nidx:category]"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="$nodeSetShortCut/nidx:note[nt:category/nt:li = $nidx:category]"/>
            </xsl:call-template>

            <link rel="up" href="../{$nidx:month}" title="{$nts:settings/nts:value[@name = 'siteName']}::{$nidx:year}-{$nidx:month}"/>

            <xsl:variable name="prev_page" select="/descendant::nidx:note[@id &lt; $nodeSetShortCut/nidx:note[1]/@id][nt:category/nt:li = $nidx:category][last()]/ancestor::nidx:day"/>
            <xsl:if test="$prev_page">
                <link rel="prev" href="{$nidx:rootPath}/{$prev_page[1]/ancestor::nidx:year/@num}/{$prev_page[1]/parent::nidx:month/@num}/{$prev_page[1]/@num}" title="{$nts:settings/nts:value[@name = 'SiteName']}::{$prev_page[1]/ancestor::nidx:year/@num}-{$prev_page[1]/parent::nidx:month/@num}-{$prev_page[1]/@num}"/>
            </xsl:if>
            <xsl:variable name="next_page" select="/descendant::nidx:note[@id &gt; $nodeSetShortCut/nidx:note[last()]/@id][nt:category/nt:li = $nidx:category][1]/ancestor::nidx:day"/>
            <xsl:if test="$next_page">
                <link rel="next" href="{$nidx:rootPath}/{$next_page[1]/ancestor::nidx:year/@num}/{$next_page[1]/parent::nidx:month/@num}/{$next_page[1]/@num}" title="{$nts:settings/nts:value[@name = 'SiteName']}::{$next_page[1]/ancestor::nidx:year/@num}-{$next_page[1]/parent::nidx:month/@num}-{$next_page[1]/@num}"/>
            </xsl:if>
        </sdf:meta>
        <sdf:body>
            <xsl:call-template name="listNotes">
                <xsl:with-param name="target" select="/nidx:index/nidx:year[@num = $nidx:year]/nidx:month[@num = $nidx:month]/nidx:day[@num = $nidx:day]/nidx:note"/>
                <xsl:with-param name="layer" select="3"/>
                <xsl:with-param name="category" select="$nidx:category"/>
            </xsl:call-template>
        </sdf:body>
    </sdf:document>
</xsl:template>

</xsl:stylesheet>