<?php
ini_set("include_path", ini_get("include_path") . PATH_SEPARATOR . dirname(__FILE__) . "/Xnm_XmlNoteManager");
/**
 * Main class of Xml Note Manager.
 * 
 * @author Arielworks
 * @license Public Domain
 */
class Xnm_XmlNoteManager {
    /**
     * Timezone offset in minute.
     * Initialized by the constructor.
     * @access private
     */
    private $timezoneOffset = 0;

    /**
     * DataManager to access data storages.
     * Initialized by the constructor.
     * @access private
     */
    private $dataManager = NULL;



    /**
     * Contructor, loads settings and initialize member variables.
     * @access public
     */
    public function __construct() {
        $this->timezoneOffset = Xnm_SettingManager::getValue("TimezoneOffset");

        $dmType = Xnm_SettingManager::getValue("DataStorage");
        try {
            Xnm_DataManager::initialize($dmType, $this->timezoneOffset);
        } catch (Exception $e) {
            $this->outputError($e->getMessage());
            exit();
        }
        $this->dataManager = Xnm_DataManager::getInstance();
    }

    /**
     * Triger method to start processing. Most procedure of XNM are defined in
     * this method.
     * @access public
     */
    public function setDataToContainer($id, $formatType, $dataContainer, $rootPath) {
        if ($_POST["action"] == "comment" && preg_match('!^(?:/([^/]+?))??(?:/(\d{4})(?:/(0[1-9]|1[0-2])(?:/(0[1-9]|[12][0-9]|3[01])(?:/([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9]))?)?)?)?$!', $id, $queryFragments)) {
            try {
                $this->recieveComment($_POST["target"], $_POST["name"], $_POST["identifier"], $_POST["message"]);
            } catch(Exception $e) {
                throw new Hml_InvalidIdException();
            }

            array_shift($queryFragments);
            list($qCategory,$qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond) = $queryFragments;
            try {
                $dataContainer->setData($this->makeStandardSdf($rootPath, $qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond, $qCategory ? $qCategory : "ALL"));
            } catch(Exception $e) {
                throw new Hml_InvalidIdException();
            }


        } elseif (preg_match('!^(?:/([^/]+?))??/latest$!', $id, $queryFragments)) {
            try {
                $dataContainer->setData($this->makeLatestSdf($rootPath, $queryFragments[1] ? $queryFragments[1] : "ALL", $formatType));
            } catch(Exception $e) {
                throw new Hml_InvalidIdException();
            }

        } elseif (preg_match('!^(?:/([^/]+?))??(?:/(\d{4})(?:/(0[1-9]|1[0-2])(?:/(0[1-9]|[12][0-9]|3[01])(?:/([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9]))?)?)?)?$!', $id, $queryFragments)) {
            array_shift($queryFragments);
            list($qCategory,$qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond) = $queryFragments;
            try {
                $dataContainer->setData($this->makeStandardSdf($rootPath, $qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond, $qCategory ? $qCategory : "ALL"));
            } catch(Exception $e) {
                throw new Hml_InvalidIdException();
            }

        } else {
            throw new Hml_InvalidIdException();
        }
    }


    public function excuteAlone($id, $extension, $accept, $acceptLang) {
         if ($extension = "trackback" && preg_match('!^/(\d{4})/(0[1-9]|1[0-2])/(0[1-9]|[12][0-9]|3[01])/([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9])$!', $id, $queryFragments)) {
            array_shift($queryFragments);
            list($qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond) = $queryFragments;
            $tgtTimestamp = gmmktime($qHour, $qMinute - $this->timezoneOffset, $qSecond, $qMonth, $qDay, $qYear);
            $this->recieveTrackbackAndResponse($tgtTimestamp, $_POST["url"], $_POST["title"], $_POST["blog_name"], $_POST["excerpt"]);

        }
    }

    /**
     * Output chronological ordered pages via HIMMEL Core.
     * @access protected
     * @param integer year Target year, default value is NULL.
     * @param integer month Target month, default value is NULL.
     * @param integer day Target day, default value is NULL.
     * @param integer hour Target hour, default value is NULL.
     * @param integer minute Target minute, default value is NULL.
     * @param integer second Target minute, default calu is NULL.
     * @param string category Category name to filter the entries.
     */
    protected function makeStandardSdf($rootPath, $year = NULL, $month = NULL, $day = NULL, $hour = NULL, $minute = NULL, $second = NULL, $category = "ALL") {
        $indexDom = $this->dataManager->getIndex();
        $indexXp = new DomXpath($indexDom);
        Hml_Util::registerBasicNs($indexXp);

        $domXsl = new DomDocument();
        if ($second !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year']/nidx:month[@num = '$month']/nidx:day[@num = '$day']/nidx:note[@num = '$hour$minute$second']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/Xnm_XmlNoteManager/IndexToSdfIndividual.xsl");
            } else {
                throw new Exception("TargetNotFound");
            }
        } elseif ($day !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year']/nidx:month[@num = '$month']/nidx:day[@num = '$day' and nidx:note/nt:category/nt:li = '$category']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/Xnm_XmlNoteManager/IndexToSdfDaily.xsl");
            } else {
                throw new Exception("TargetNotFound");
            }
        } elseif ($month !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year']/nidx:month[@num = '$month' and nidx:day/nidx:note/nt:category/nt:li = '$category']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/Xnm_XmlNoteManager/IndexToSdfMonthly.xsl");
            } else {
                throw new Exception("TargetNotFound");
            }
        } elseif ($year !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year' and nidx:month/nidx:day/nidx:note/nt:category/nt:li = '$category']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/Xnm_XmlNoteManager/IndexToSdfYearly.xsl");
            } else {
                throw new Exception("TargetNotFound");
            }
        } else {
            $domXsl->load(dirname(__FILE__) . "/Xnm_XmlNoteManager/IndexToSdfHome.xsl");
        }

        $xsltp = new XsltProcessor();
        $xsltp->registerPhpFunctions();
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "category", $category);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "year", $year);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "month", $month);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "day", $day);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "hour", $hour);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "minute", $minute);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "second", $second);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "webPrefix", "http://" . $_SERVER["HTTP_HOST"]);
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "rootPath", $rootPath);
        $xsltp->importStyleSheet($domXsl);
        $sdfDom = $xsltp->transformToDoc($indexDom);

        return $sdfDom;
    }


    /**
     * Output the latest entries via HIMMEL Core (XHTML).
     * @access protected
     * @param string category Category name to filter the entries.
     */
    protected function makeLatestSdf($rootPath, $category = "ALL", $formatType) {
        $indexDom = $this->dataManager->getIndex();
        $indexXp = new DomXpath($indexDom);
        Hml_Util::registerBasicNs($indexXp);

        if ($indexXp->query("/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note/nt:category/nt:li[. = '$category']")->item(0)) {
            $domXsl = new DomDocument();
            if ($formatType == Hml_OutputDefinition::RICH) {
                $domXsl->load(dirname(__FILE__) . "/Xnm_XmlNoteManager/IndexToSdfLatestRich.xsl");
            } elseif ($formatType == Hml_OutputDefinition::SIMPLE) {
                $domXsl->load(dirname(__FILE__) . "/Xnm_XmlNoteManager/IndexToSdfLatestSimple.xsl");
            }
            $xsltp = new XsltProcessor();
            $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "category", $category);
            $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "webPrefix", "http://" . $_SERVER["HTTP_HOST"]);
            $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "rootPath", $rootPath);
            $xsltp->registerPhpFunctions();
            $xsltp->importStyleSheet($domXsl);
            $sdfDom = $xsltp->transformToDoc($indexDom);

            return $sdfDom;
        }
    }

    /**
     * Method to recieve Trackback Pings and response.
     * @access protected
     * @param integer targetId ID of the entry that recieved the ping.
     * @param string url URL/URI of the sender entry/page.
     * @param string title Title of the sender entry/page.
     * @param string blogName Name of the sender blog.
     * @param string except Excerpt of the sender entry/page.
     */
    protected function recieveTrackbackAndResponse($targetId, $url, $title, $blogName, $excerpt) {
        // Except "&", do not HTML-sanitize these inputs now, leave to DomDocument.
        $url = str_replace("&", "&amp;", $url);
        $title = str_replace("&", "&amp;", $title);
        $blogName = str_replace("&", "&amp;", $blogName);
        $excerpt = str_replace("&", "&amp;", $excerpt);

        header("Content-Type: text/xml");
        print '<?xml version="1.0" encoding="UTF-8"?>';

        if (! $url || strlen($url) > 256) {
            print '<response><error>1</error><message>URI NOT VALID</message></response>';
        } elseif (strlen($title) > 256) {
            print '<response><error>1</error><message>TITLE TOO LONG</message></response>';
        } elseif (strlen($blogName) > 256) {
            print '<response><error>1</error><message>BLOG NAME TOO LONG</message></response>';
        } elseif (strlen($excerpt) > 256) {
            print '<response><error>1</error><message>EXCERPT TOO LONG</message></response>';
        } else {
            try {
                $this->dataManager->saveTrackBack($targetId, $url, $title, $blogName, $excerpt);
                print '<response><error>0</error></response>';
            } catch (Exception $e) {
                print "<response><error>1</error><message>EXCEPTION</message></response>";
            }
        }
    }


    /**
     * Method to recieve comments. Snitize inputs and save them.
     * @access protected
     * @param integer targetId ID of the entry that recieved the ping.
     * @param string name Name of the sender.
     * @param string Identifier URI of web site or EMail address of the sender.
     * @param string message Message body.
     */
    protected function recieveComment($targetId, $name, $identifier, $message) {
        // Except "&", do not HTML-sanitize these inputs now, leave to DomDocument.
        $name = str_replace("&", "&amp;", $name);
        $identifier = str_replace("&", "&amp;", $identifier);
        $message = str_replace("&", "&amp;", $message);

        if (strlen($name) > 256) {
            exit("namae nagasugi");
        } elseif (strlen($identifier) > 256) {
            exit("Identifier nagasugi");
        } elseif (! $message) {
            exit("message ne");
        } elseif (strlen($message) > 1024) {
            exit("message nagasugi");
        } else {
            try {
                $this->dataManager->saveComment($targetId, $name, $identifier, $message);
            } catch (Exception $e) {
                throw $e;
            }
        }
    }
}
?>