<?php
class Xnm_DataControllerFileSystemRNote extends Xnm_DataControllerFileSystem {

    protected function getItratorToBuildIndex() {
        return new Xnm_ItratorToBuildIndexFileSystemRNote($this->getFileList()); 
    }

    public function loadData($internalId) {
        $targetDom = parent::loadData($internalId);
        $targetXp = new DomXpath($targetDom);
        $targetXp->registerNamespace("rnote", "http://rinn.e-site.jp/rnote/");
        if ($targetXp->query("/rnote:rNote")->item(0)) {
            $domXsl = new DomDocument();
            $domXsl->load("RNoteToXnm.xsl");
            $xsltp = new XsltProcessor();
            $xsltp->importStyleSheet($domXsl);
            $targetDom = $xsltp->transformToDoc($targetDom);
        }
        return $targetDom;
    }
}

class Xnm_ItratorToBuildIndexFileSystemRNote extends Xnm_ItratorToBuildIndexFileSystem {

    public function __construct($dataDirectory) {
        parent::__construct($dataDirectory);
    }

    public function next() {
        $result = parent::next();
        $dom = $result["dom"];

        $xp = new DomXpath($dom);
        $xp->registerNamespace("rnote", "http://rinn.e-site.jp/rnote/");
        if ($xp->query("/rnote:rNote")->item(0)) {
            $domXsl = new DomDocument();
            $domXsl->load("RNoteToXnm.xsl");
            $xsltp = new XsltProcessor();
            $xsltp->importStyleSheet($domXsl);
            $dom = $xsltp->transformToDoc($dom);
        }

        $result["dom"] = $dom;
        return $result;
    }
}
?>