<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/"
                              exclude-result-prefixes="php nt nidx">

<xsl:param name="year"/>
<xsl:param name="nidx:year" select="$year"/>
<xsl:param name="month"/>
<xsl:param name="nidx:month" select="$month"/>
<xsl:param name="day"/>
<xsl:param name="nidx:day" select="$day"/>
<xsl:param name="hour"/>
<xsl:param name="nidx:hour" select="$hour"/>
<xsl:param name="minute"/>
<xsl:param name="nidx:minute" select="$minute"/>
<xsl:param name="second"/>
<xsl:param name="nidx:second" select="$second"/>

<xsl:param name="nts:settings" select="document('./settings.xml')/nts:settings"/>

<xsl:template name="nidx:copy_oldest_created">
    <xsl:param name="nidx:targets_dom"/>

    <xsl:for-each select="$nidx:targets_dom">
        <xsl:sort select="./@timestamp" data-type="number"/>
            <xsl:if test="position() = 1">
                <xsl:copy-of select="./dcterms:created"/>
            </xsl:if>
    </xsl:for-each>
</xsl:template>

<xsl:template name="nidx:copy_latest_modified">
    <xsl:param name="nidx:targets_dom"/>

    <xsl:for-each select="$nidx:targets_dom">
        <xsl:sort select="php:function('Xnm_DataManager::getLatestModified', .)" order="descending"/>
        <xsl:if test="position() = 1">
            <dcterms:modified xsi:type="dcterms:W3CDTF">
                <xsl:choose>
                    <xsl:when test="./dcterms:modified">
                        <xsl:value-of select="./dcterms:modified"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="./dcterms:created"/>
                    </xsl:otherwise>
                </xsl:choose>
            </dcterms:modified>
        </xsl:if>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>