<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'siteName']"/>
                <xsl:text>::Latest Notes</xsl:text>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="./nidx:note"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="./nidx:note"/>
            </xsl:call-template>
            <link rel="up" href="../archive" title="{$nts:settings/nts:value[@name = 'siteName']}"/>
        </sdf:meta>
        <sdf:body>
            <p>最近の15件分。</p>
            <xsl:for-each select="./nidx:note">
                <xsl:sort select="./@timestamp" data-type="number" order="descending"/>
                    <xsl:if test="position() &lt;= 15">
                    <xsl:variable name="nidx:current_note" select="php:function('Xnm_DataManager::document', string(./@internal_id))"/>
                    <sdf:section>
                        <sdf:meta>
                            <xsl:copy-of select="$nidx:current_note/nt:note/*[not(local-name() = 'body' and namespace-uri() = 'http://www.arielworks.net/works/codeyard/himmel/xnm')]"/>
                        </sdf:meta>
                        <sdf:body>
                            <xsl:copy-of select="$nidx:current_note/nt:note/nt:body/node()"/>
                        </sdf:body>
                    </sdf:section>
                </xsl:if>
            </xsl:for-each>
        </sdf:body>
    </sdf:document>
</xsl:template>

</xsl:stylesheet>