<?php
/**
 * @author  Arielworks
 * @access public
 * @version 1.2.0
 * @license Public Domain
 */
class Himmel_OutputDefinitionRss10 extends Himmel_OutputDefinition {
    protected $encoding              = "UTF-8";

    public function outputToHttp($outputUnit) {
        $msgBody = $this->makeMassageBody();
        $outputUnit->setMassageBody($msgBody);
        $outputUnit->setHeader("Content-Type", "application/rss+xml");
    }

    protected function makeMassageBody() {
        $resultDom = $this->transformSdf($this->sourceContainer);
        $resultStr = $resultDom->saveXML();
        return $resultStr;
    }

    protected function transformSdf($sourceContainer) {
        $domXsl = new Domdocument();
        $domXsl->load(dirname(__FILE__) . "/" . $xslFilePath);

        $xsltp = new XsltProcessor();
        $xsltp->importStyleSheet($domXsl);
        foreach ($parameters as $aParam) {
            $xsltp->setParameter($aParam[0], $aParam[1], $aParam[2]);
        }
        return $xsltp->transformToDoc($xmlDom);
    }

}
?>