<?php
/**
 * The container to store DOM Object and provide easy access method
 * 
 * @author Arielworks
 * @access public
 * @version 1.0.0
 * @license Public Domain
 */
class Himmel_DataContainer {
    /**
     * @access private
     */
    private $dataDom = NULL;
    private $dataXpath = NULL;
    private $nsUriList = array(
        "sdf"     => "http://www.arielworks.net/works/codeyard/sdf",
        "hml"     => "http://www.arielworks.net/works/codeyard/himmel",
        "dc"      => "http://purl.org/dc/elements/1.1/",
        "dcterms" => "http://purl.org/dc/terms/"
    );

    /**
     * @return void
     * @access public
     */
    public function __construct() {
        $tmpl = new DomDocument();
        $tmpl->load(dirname(__FILE__) . "/SdfTemplate.xml");
        $this->setData($tmpl);
    }

    /**
     * @return void
     * @param DomDoument $newDataDom DomDocument to store
     * @access public
     */
    public function setData(DomDocument $newDataDom) {
        $this->dataDom = $newDataDom;
        $this->dataXpath = new DomXpath($this->dataDom);
        foreach ($this->nsUriList as $nsPrefix => $nsUri) {
            $this->dataXpath->registerNameSpace($nsPrefix, $nsUri);
        }
    }

    public function appendBodyData(DOMNode $fragment) {
        $fragmentNode = $this->dataDom->importNode($fragment, TRUE);
        $this->dataXpath->query("/sdf:document/sdf:body")->item(0)->appendChild($fragmentNode);
    }

    public function setId($newId) {
        $this->dataXpath->query("/sdf:document/sdf:meta")->item(0)->appendChild($this->dataDom->createElement("sdf:id", $newId));
    }

    public function setBackEndName($newName) {
        $this->dataXpath->query("/sdf:document")->item(0)->setAttributeNS($this->nsUriList["hml"], "hml:backendname", $newName);
    }

    public function setTitle($newTitle) {
        $titleNode = $this->dataDom->importNode($newTitle, TRUE);
        $this->dataXpath->query("/sdf:document/sdf:meta/dc:title")->item(0)->appendChild($titleNode);
    }

    public function setCreatedDatetime($datetime) {
        if ($this->isW3cDtf($datetime)) {
            $this->dataXpath->query("/sdf:document/sdf:meta/dcterms:created")->item(0)->appendChild($this->dataDom->createTextNode($datetime));
        } else {
            throw new Himmel_DateFormatNotW3cdtfException();
        }
    }

    /**
     * @return DomDocument
     * @access public
     */
    public function getData() {
        return $this->dataDom;
    }

    public function getTitle() {
    }

    public function getCreatedDatetime() {
        $nodeList = $this->dataXpath->query("/sdf:document/sdf:meta/dcterms:created/node()");
        if ($nodeList->item(0)) {
            $value = $this->dataDom->saveXML($nodeList->item(0));
            if ($value && $this->isW3cDtf($value)) {
                return $value;
            } else {
                throw new Himmel_DateFormatNotW3cdtfException("Created");
            }
        } else {
            return FALSE;
        }
    }

    public function getModifiedDatetime() {
        $nodeList = $this->dataXpath->query("/sdf:document/sdf:meta/dcterms:modified/node()");
        if ($nodeList->item(0)) {
            $value = $this->dataDom->saveXML($nodeList->item(0));
            if ($value && $this->isW3cDtf($value)) {
                return $value;
            } else {
                throw new Himmel_DateFormatNotW3cdtfException("Modified");
            }
        } else {
            try {
                $alt = $this->getCreatedDatetime();
                return $alt;
            } catch (Himmel_DateFormatNotW3cdtfException $e) {
                throw $e;
            }
        }
    }

    public function getCreator() {
    }

    protected function isW3cDtf($str) {
        return preg_match('/^(\d{4})(?:-(0[1-9]|1[0-2])(?:-(0[1-9]|[12][0-9]|3[0-1])(?:T([0-5][0-9]):([0-5][0-9])(?::([0-5][0-9])(?:\.(\d+))?)?(Z|(?:\+|-)[0-5][0-9]:[0-5][0-9]))?)?)?$/', $str);
    }
}
?>