package jp.hrtdotnet.java.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;

import jp.hrtdotnet.java.io.HFile;
import junit.framework.TestCase;

public class HPropertiesTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#HProperties()} ̂߂̃eXgE\bhB
     */
    public void testHProperties() {
        HProperties prop = new HProperties();
        if (prop instanceof Properties == false) {
            fail();
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#HProperties(jp.hrtdotnet.java.util.HProperties)} ̂߂̃eXgE\bhB
     */
    public void testHProperties_HProperties() {
        HProperties prop2 = new HProperties();
        String key = "key1";
        String value = "value1";
        prop2.setProperty(key, value);
        HProperties prop = new HProperties(prop2);
        if (prop instanceof Properties == false) {
            fail();
        }
        assertEquals(prop.getProperty(key), value);
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#setProperty(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetProperty_StringString() {
        HProperties prop = new HProperties();
        String key = "key1";
        String value = "value1";
        prop.setProperty(key, value);
        assertEquals(prop.getProperty(key), value);
        value = "o[Q";
        prop.setProperty(key, value);
        assertEquals(prop.getProperty(key), value);

        System.out.println("******** testSetProperty_StringString start ********");
        prop = new HProperties();
        prop.setProperty("PPPPP", "");
        prop.setProperty("QQQQQ", "");
        prop.list(System.out);
        prop.setProperty("PPPPP", "");
        prop.list(System.out);
        System.out.println("******** testSetProperty_StringString end ********");
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#put(java.lang.Object, java.lang.Object)} ̂߂̃eXgE\bhB
     */
    public void testPut_ObjectObject() {
        HProperties prop = new HProperties();
        String key = "key1";
        String value = "value1";
        prop.put(key, value);
        assertEquals(prop.get("key1"), value);
        value = "o[Q";
        prop.setProperty(key, value);
        assertEquals(prop.getProperty("key1"), value);
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#keys()} ̂߂̃eXgE\bhB
     */
    public void testKeys() {
        HProperties prop = new HProperties();
        String key1 = "key1";
        String value1 = "value1";
        prop.setProperty(key1, value1);
        String key2 = "L[Q";
        String value2 = "o[Q";
        prop.setProperty(key2, value2);
        String key3 = "key3";
        String value3 = "value3";
        prop.setProperty(key3, value3);
        Enumeration enumeration = prop.keys();
        int count = 0;
        while(enumeration.hasMoreElements()) {
            count++;
            String key = (String)enumeration.nextElement();
            if(key1.equals(key)) {
                continue;
            } else if (key2.equals(key)) {
                continue;
            } else if (key3.equals(key)) {
                continue;
            }
            fail();
        }
        assertEquals(count, 3);
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#propertyNames()} ̂߂̃eXgE\bhB
     */
    public void testPropertyNames() {
        HProperties prop = new HProperties();
        String key1 = "key1";
        String value1 = "value1";
        prop.setProperty(key1, value1);
        String key2 = "L[Q";
        String value2 = "o[Q";
        prop.setProperty(key2, value2);
        String key3 = "key3";
        String value3 = "value3";
        prop.setProperty(key3, value3);
        Enumeration enumeration = prop.propertyNames();
        int count = 0;
        while(enumeration.hasMoreElements()) {
            count++;
            String key = (String)enumeration.nextElement();
            if(key1.equals(key)) {
                continue;
            } else if (key2.equals(key)) {
                continue;
            } else if (key3.equals(key)) {
                continue;
            }
            fail();
        }
        assertEquals(count, 3);
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#getProperty(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetProperty_String() {
        HProperties prop = new HProperties();
        String key = "key1";
        String value = "value1";
        prop.setProperty(key, value);
        assertEquals(prop.getProperty(key), value);
        value = "o[Q";
        prop.setProperty(key, value);
        assertEquals(prop.getProperty(key), value);
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#getProperty(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetProperty_StringString() {
        HProperties prop = new HProperties();
        String key = "key1";
        String value = "value1";
        prop.setProperty(key, value);
        assertEquals(prop.getProperty(key), value);
        key = "L[Q";
        assertEquals(prop.getProperty(key, "l"), "l");
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#get(java.lang.Object)} ̂߂̃eXgE\bhB
     */
    public void testGet_Object() {
        HProperties prop = new HProperties();
        String key = "key1";
        String value = "value1";
        prop.setProperty(key, value);
        assertEquals((String)prop.get(key), value);
        value = "o[Q";
        prop.setProperty(key, value);
        assertEquals((String)prop.get(key), value);
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#store(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testStore_StringString() throws IOException {
        File f = new File("src/test/resources/jp/hrtdotnet/java/util/HPropertiesTest.properties");
        String tmp = System.getProperty("java.io.tmpdir") + File.separator + "HPropertiesTest1_" + Calendar.getInstance().getTime().getTime() + ".properties";
        File f2 = new File(tmp);
        if (f2.exists()) {
            throw new RuntimeException(tmp + " is exists.");
        }
        HFile.copy(f, f2);
        HProperties prop = new HProperties();
        prop.setProperty("QQQQQ", "");
        prop.setProperty("PPPPP", "");
        prop.store(tmp, "marge");
        f2.delete();
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#store(java.lang.String, java.lang.String, boolean)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testStore_StringStringBoolean() throws IOException {
        HProperties prop = new HProperties();
        prop.setProperty("QQQQQ", "");
        prop.setProperty("PPPPP", "");

        File f = new File("src/test/resources/jp/hrtdotnet/java/util/HPropertiesTest.properties");
        String tmp = System.getProperty("java.io.tmpdir") + File.separator + "HPropertiesTest2_" + Calendar.getInstance().getTime().getTime() + ".properties";
        File f2 = new File(tmp);
        if (f2.exists()) {
            throw new RuntimeException(tmp + " is exists.");
        }
        HFile.copy(f, f2);
        prop.store(tmp, "marge2", true);
        f2.delete();

        tmp = System.getProperty("java.io.tmpdir") + File.separator + "HPropertiesTest3_" + Calendar.getInstance().getTime().getTime() + ".properties";
        f2 = new File(tmp);
        if (f2.exists()) {
            throw new RuntimeException(tmp + " is exists.");
        }
        HFile.copy(f, f2);
        prop = new HProperties();
        prop.setProperty("QQQQQ", "");
        prop.setProperty("PPPPP", "");
        prop.store(tmp, "set", false);
        f2.delete();
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#store(java.io.OutputStream, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testStore_OutputStreamString() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#list(java.io.PrintStream)} ̂߂̃eXgE\bhB
     */
    public void testList_PrintStream() {
        HProperties prop = new HProperties();
        prop.setProperty("QQQQQ", "");
        prop.setProperty("PPPPP", "");
        prop.setProperty("333333", "abcde");
        prop.list(System.out);
    }

    /**
     * {@link jp.hrtdotnet.java.util.HProperties#list(java.io.PrintWriter)} ̂߂̃eXgE\bhB
     * @throws FileNotFoundException 
     */
    public void testList_PrintWriter() throws FileNotFoundException {
        //ڎmF
        HProperties prop = new HProperties();
        prop.setProperty("QQQQQ", "");
        prop.setProperty("PPPPP", "");
        prop.setProperty("333333", "abcde");

        String tmp = System.getProperty("java.io.tmpdir") + File.separator + "HPropertiesTest10_" + Calendar.getInstance().getTime().getTime() + ".properties";
        File f2 = new File(tmp);
        if (f2.exists()) {
            throw new RuntimeException(tmp + " is exists.");
        }
        PrintWriter pw = new PrintWriter(new FileOutputStream(f2));
        prop.list(pw);
        pw.close();
    }

}
