/*
 * Created on 2005/06/09
 *
 */
package jp.co.areaweb.tools.core;

import jp.co.areaweb.tools.core.Tax;
import junit.framework.TestCase;

/**
 * @author y_hayashi
 *
 */
public class TestTax extends TestCase {

	/**
	 * テスト１
	 * 総額から税引き価格を求める
	 */
	public void test001() throws Exception {
		assertEquals(95L, Tax.calcBody(100L));
		assertEquals(5L, Tax.calcTax(100L));
		assertEquals(5L, Tax.toTax(95L));
		assertEquals(100L, Tax.toTotal(95L));
	}
	
	/**
	 * テスト2
	 * 端数は四捨五入されること
	 */
	public void test002() throws Exception {
		assertEquals(99L, Tax.calcBody(104L));		// 99.04
		assertEquals(5L, Tax.calcTax(104L));
		assertEquals(100L, Tax.calcBody(105L));		// 100.0
		assertEquals(5L, Tax.calcTax(105L));
		assertEquals(101L, Tax.calcBody(106L));		// 100.9
		assertEquals(5L, Tax.calcTax(106L));
		assertEquals(102L, Tax.calcBody(107L));		// 101.9
		assertEquals(5L, Tax.calcTax(106L));

		assertEquals(5L, Tax.toTax(99L));
		assertEquals(104L, Tax.toTotal(99L));
		assertEquals(5L, Tax.toTax(100L));
		assertEquals(105L, Tax.toTotal(100L));
		assertEquals(5L, Tax.toTax(101L));
		assertEquals(106L, Tax.toTotal(101L));
		assertEquals(5L, Tax.toTax(102L));
		assertEquals(107L, Tax.toTotal(102L));
	}

	/**
	 * テスト3
	 * 10兆円までは計算できる。
	 */
	public void test003() throws Exception {
		try {
			assertEquals(9523809523810L, Tax.calcBody(10000000000000L));
			assertEquals(476190476190L, Tax.calcTax(10000000000000L));
			assertEquals(500000000000L, Tax.toTax(10000000000000L));
			assertEquals(10500000000000L, Tax.toTotal(10000000000000L));
		}
		catch (Exception e) {
			fail();		// 例外が発生
		}
	}

	/**
	 * テスト4
	 * 数値が負の場合
	 */
	public void test004() throws Exception {
		assertEquals(-95L, Tax.calcBody(-100L));
		assertEquals(-5L, Tax.calcTax(-100L));
		assertEquals(-5L, Tax.toTax(-95L));
		assertEquals(-100L, Tax.toTotal(-95L));
	}
}
