(provide 'hatena-vars)

(defgroup hatena nil
  "major mode for Hatena::Diary"
  :prefix "hatena-"
  :group 'hypermedia)

(defgroup hatena-face nil
  "Hatena, Faces."
  :prefix "hatena-"
  :group 'hatena)

(defcustom hatena-usrid nil
  "hatena-diary-mode Υ桼̾"
  :type 'string
  :group 'hatena)

(defcustom hatena-directory 
  (expand-file-name "~/.hatena/")
  "¸ǥ쥯ȥ."
  :type 'directory
  :group 'hatena)

(defcustom hatena-init-file (concat
			     (file-name-as-directory hatena-directory)
			     "init")
  "*hatena-diary-mode νե롣"
  :type 'file
  :group 'hatena)

(defcustom hatena-password-file 
  (expand-file-name (concat hatena-directory ".password"))
  "ѥ¸ե"
  :type 'file
  :group 'hatena)

(defcustom hatena-entry-type 1
  "ȥΥޡå * ɤΤ褦˽뤫
0ʤ *  *pn* ˡ1 ʤ *  *<time>* ֤"
  :type 'integer
  :group 'hatena)

(defcustom hatena-change-day-offset 6
  "ϤƤʤ, դѤ .+6 Ǹ 6 դѹ."
  :type 'integer
  :group 'hatena)

(defcustom hatena-trivial nil
  "äȤ򤹤뤫ɤ. non-nil \"äȤ\"ˤʤ"
  :type 'boolean
  :group 'hatena)

(defcustom hatena-use-file t
  "ѥɤ(Ź沽)¸뤫ɤ non-nil ʤѥɤ base 64 ǥ󥳡ɤ¸"
  :type 'boolean
  :group 'hatena)

(defcustom hatena-cookie 
  (expand-file-name 
   (concat hatena-directory "Cookie@hatena"))
  "å̾"
  :type 'file
  :group 'hatena)

(defcustom hatena-browser-function nil  ;; ̤ϡ'browse-url
  "Function to call browser.
If non-nil, `hatena-submit' calls this function.  The function
is expected to accept only one argument(URL)."
  :type 'symbol
  :group 'hatena)

(defcustom hatena-proxy ""
  "curl ɬפʻꤹ"
  :type 'string
  :group 'hatena)

(defcustom hatena-default-coding-system 'euc-jp
  "ǥեȤΥǥ󥰥ƥ"
  :type 'symbol
  :group 'hatena)


(defcustom hatena-url "http://d.hatena.ne.jp/"
  "ϤƤʤΥɥ쥹"
  :type 'string
  :group 'hatena)

(defcustom hatena-twitter-flag nil
  "twitterΤ򤹤뤫ɤ. non-nil \"twitter\"ˤʤ"
  :type 'boolean
  :group 'hatena)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;եɽ
(defvar hatena-fname-regexp
  "\\([0-9][0-9][0-9][0-9]\\)\\([01][0-9]\\)\\([0-3][0-9]\\)$" )
(defvar hatena-diary-mode-map nil)

;;Ť
(defvar hatena-header-regexp 
  (concat "\\`      Title: \\(.*\\)\n"
          "Last Update: \\(.*\\)\n"
          "____________________________________________________" ))

(defvar hatena-tmpfile 
  (expand-file-name (concat hatena-directory "hatena-temp.dat")))
(defvar hatena-tmpfile2
  (expand-file-name (concat hatena-directory "hatena-temp2.dat")))
(defvar hatena-curl-command "curl" "curl ޥ")

(defvar hatena-twitter-prefix nil "twitterƤ")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;face

(defvar hatena-font-lock-keywords nil)
(defvar hatena-html-face 'hatena-html-face)
(defvar hatena-title-face 'hatena-title-face)
(defvar hatena-header-face 'hatena-header-face)
(defvar hatena-subtitle-face 'hatena-subtitle-face)
(defvar hatena-markup-face 'hatena-markup-face)
(defvar hatena-link-face 'hatena-link-face)

(defface hatena-title-face
  '((((class color) (background light)) (:foreground "Navy" :bold t))
    (((class color) (background dark)) (:foreground "wheat" :bold t)))
  "title face"
  :group 'hatena-face)

(defface hatena-header-face
  '((((class color) (background light)) (:foreground "Gray70" :bold t))
    (((class color) (background dark)) (:foreground "SkyBlue4" :bold t)))
  "last update face"
  :group 'hatena-face)

(defface hatena-subtitle-face 
  '((((class color) (background light)) (:foreground "DarkOliveGreen"))
    (((class color) (background dark)) (:foreground "wheat")))
  "֥ȥface"
  :group 'hatena-face)

(defface hatena-markup-face 
  '((((class color) (background light)) (:foreground "firebrick" :bold t))
    (((class color) (background dark)) (:foreground "IndianRed3" :bold t)))
  "ϤƤʤΥޡåפface"
  :group 'hatena-face)

(defface hatena-html-face 
  '((((class color) (background light)) (:foreground "DarkSeaGreen4"))
    (((class color) (background dark)) (:foreground "Gray50")))
  "htmlface"
  :group 'hatena-face)

(defface hatena-link-face 
  '((((class color) (background light)) (:foreground "DarkSeaGreen4"))
    (((class color) (background dark)) (:foreground "wheat")))
  "htmlǶޤ줿ʬface"
  :group 'hatena-face)

;-----------------------------------------------------------------------------------
; ϤƤʵˡإ
;-----------------------------------------------------------------------------------
(defvar hatena-help-syntax-index
  'dummy
  "ϻٱ絭ˡ `hatena-help-syntax-input'
   ư `hatena-help-syntax-autolink'
   ϤƤ⼫ư `hatena-help-syntax-hatena-autolink'
   ϻٱ絡ǽ `hatena-help-syntax-other'")

(defvar hatena-help-syntax-input
  'dummy
  "ϻٱ絭ˡ

|------------------------------+------------------------------+-----------------------------------------------------|
| ˡ̾                       |                          | ǽ                                                |
|------------------------------+------------------------------+-----------------------------------------------------|
| Фˡ                   | *                        | ˸Фh3ˤդޤ                        |
| դФˡ           | *t*, *t+1*           | ФԽ¸ɽޤ                  |
| name°դФˡ       | *name*                   | Ф˹ name °Ĥޤ                  |
| ƥ꡼ˡ               | *[]                  | ˥ƥ꡼ꤷޤ                        |
| Фˡ                 | **                       | ˾Фh4ˤĤޤ                      |
| Фˡ               | ***                      | ˾Фˡh5ˤĤޤ                |
| ꥹȵˡ                   | -, --, +, ++ | ꥹȡliˤñ˵Ҥޤ                      |
| ꥹȵˡ               | ::                   | ꥹȡdtˤñ˵Ҥޤ                  |
| ɽȤߵˡ                   | |   |   |            | ɽȤߡtableˤñ˵Ҥޤ                   |
|                              | |*  |   |            |                                                     |
| ѵˡ                     | >>  <<                   | ѥ֥åblockquoteˤñ˵Ҥޤ        |
| preˡ                      | >|  |<                   | ƥȤ򤽤Τޤɽޤpre         |
| ѡpreˡ              | >||  ||<                 | HTMLʤɤΥ򤽤Τޤɽޤpre |
| ѡpreˡ              | >|ե륿|  ||<   | ץΥɤ                  |
| ʥ󥿥åϥ饤ȡ | >|??|  ||<               | դɽޤpre                         |
|                              |                              |                                                     |
| aaˡ                       | >|aa|  ||<               | Ȥñˤ줤ɽޤ            |
| ˡ                     | ((  ))                   | ˵ꤷޤ                              |
| ³ɤ൭ˡ               | ====                         | θФޤǤθ³ɤפˤޤ  |
| ѡ³ɤ൭ˡ       | =====                        | ФޤƤθƤ³ɤפˤޤ  |
| Եˡ                     | (Ϣ³ι2)        | ԡbrˤޤ                              |
| pߵˡ                | ><  ><                   | ư p ߤޤ                   |
| texˡ                      | [tex:]                   | mimeTeX Ȥäƿɽޤ                    |
| 쵭ˡ                 | [uke:]                   | Υɽޤ                      |
|------------------------------+------------------------------+-----------------------------------------------------|

ѡpreˡбƤե륿

a2ps a65 aap abap abaqus abc abel acedb actionscript ada aflex ahdl alsaconf amiga aml ampl ant antlr apache  apachestyle arch art asm asm68k asmh8300 asn aspperl aspvbs asterisk  asteriskvm atlas automake ave awk ayacc b baan basic  bc bdf  bib bindzone blank bst btm c calendar catalog cdl cf cfg ch change changelog chaskell cheetah  chill chordpro cl clean clipper cmake cobol colortest conf config context cpp crm crontab cs csc csh csp css cterm ctrlh cupl cuplsim cvs cvsrc cweb cynlib cynpp d dcd dcl debchangelog debcontrol debsources def desc desktop dictconf dictdconf diff  dircolors diva  django  dns docbk docbksgml docbkxml dosbatch dosini dot doxygen dracula dsl dtd dtml dylan dylanintr dylanlid ecd edif eiffel elf elinks elmfilt erlang eruby esmtprc esqlc esterel eterm eviews exim expect exports fasm fdcc fetchmail  fgl flexwiki  focexec form forth fortran foxpro fstab fvwm fvwm2m4 gdb  gdmo gedcom gkrellmrc gnuplot go gp gpg grads gretl groff groovy group grub gsp gtkrc haskell  hb help hercules hex hitest hog html htmlcheetah htmldjango htmlm4 htmlos ia64 icemenu icon idl idlang indent inform initex inittab ipfilter ishd iss ist jal jam jargon java javacc javascript  jess jgraph jproperties jsp kconfig kix kscript kwt lace latte ld ldif lex lftp lhaskell libao lifelines lilo limits lisp lite loginaccess logindefs logtalk lotos lout lpc lprolog lscript lss lua lynx m4 mail mailaliases mailcap make man manconf manual maple masm mason master matlab maxima  mel mf mgl mgp mib  mma mmix modconf model modsim3 modula2 modula3 monk moo mp mplayerconf mrxvtrc msidl msql mupad mush muttrc mysql named nanorc nasm nastran natural  ncf netrc netrw nosyntax nqc nroff nsis objc objcpp ocaml occam omnimark openroad opl ora pamconf papp pascal passwd pcap pccts perl pf pfmain php phtml pic pike pilrc pine pinfo plaintex plm plp plsql po pod postscr pov povini ppd ppwiz prescribe procmail progress prolog protocols psf ptcap purifylog pyrex python qf quake r racc radiance ratpoison rc rcs rcslog readline  rebol registry remind resolv rexx rhelp rib rnc rnoweb robots  rpcgen rpl rst rtf ruby samba sas sather scala scheme  scilab  screen  sdl sed sendpr sensors services setserial sgml sgmldecl sgmllnx sh sicad sieve simula sinda sindacmp sindaout sisu skill sl slang slice slpconf slpreg slpspi slrnrc slrnsc sm smarty smcl smil smith sml snnsnet snnspat snnsres snobol4 spec specman spice splint spup spyce sql  sqlanywhere sqlforms sqlinformix sqlj sqloracle sqr squid sshconfig sshdconfig st stata stp strace sudoers svn syncolor synload syntax sysctl tads tags tak takcmp takout tar tasm tcl tcsh  terminfo tex  texinfo texmf tf tidy tilde tli tpp trasys trustees tsalt tsscl tssgm tssop uc udevconf udevperm udevrules uil updatedb valgrind vb vera verilog verilogams vgrindefs vhdl  vim viminfo virata vmasm vrml vsejcl wdiff web webmacro wget  whitespace winbatch wml wsh wsml wvdial xdefaults xf86conf xhtml  xinetd xkb xmath xml xmodmap xpm xpm2 xquery xs xsd xslt  xxd yacc  yaml z8a zsh
")
	
(defvar hatena-help-syntax-autolink
  'dummy
  "ư

|--------------------+---------------------------------+--------------------------------------------|
| ˡ̾             |                             | ǽ                                       |
|--------------------+---------------------------------+--------------------------------------------|
| httpˡ           | http://                     | URLؤλϤޤ󥯤ñ˵Ҥޤ      |
|                    | [http: //:title]            |                                            |
|                    | [http://:barcode]           |                                            |
|                    | [http://:image]             |                                            |
|                    |                                 |                                            |
| mailtoˡ         | mailto:                     | ᡼륢ɥ쥹ؤΥ󥯤ñ˵Ҥޤ |
| niconicoˡ       | [niconico:sm*******]            | ˥˥ưκץ졼䡼ɽޤ   |
| googleˡ         | [google:]                   | Google θ̤˥󥯤ޤ            |
|                    | [google:image:]             |                                            |
|                    | [google:news:]              |                                            |
|                    |                                 |                                            |
| mapˡ            | map:xy (:map)           | Googleޥåפɽ󥯤ޤ         |
|                    | [map:]                      |                                            |
|                    | [map:t:]                    |                                            |
|                    |                                 |                                            |
| amazonˡ         | [amazon:]                   | Amazon θ̤˥󥯤ޤ            |
| wikipediaˡ      | [wikipedia:]                | Wikipediaε˥󥯤ޤ              |
| twitterˡ        | twitter::title            | TwitterΤĤ֤䤭˥󥯤ޤ            |
|                    | twitter::tweet            |                                            |
|                    | twitter::detail           |                                            |
|                    | twitter::detail:right     |                                            |
|                    | twitter::detail:left      |                                            |
|                    | twitter::tree             |                                            |
|                    | [twitter:@hatenadiary]        |                                            |
|                    | [http://twitter.com/hatenadiary |                                            |
|                    | /status/:twitter:title]     |                                            |
| ưߵˡ | [] ϤƤʵˡ []                | ϤƤʵˡˤ뼫ư󥯤ߤޤ     |
|--------------------+---------------------------------+--------------------------------------------|
")

(defvar hatena-help-syntax-hatena-autolink
  'dummy
  "ϤƤ⼫ư

|---------------+-------------------------------+-------------------------------------------------|
| ˡ̾        |                           | ǽ                                            |
|---------------+-------------------------------+-------------------------------------------------|
| idˡ        | id: id::archive     | ϤƤʥ桼˥󥯤                      |
|               | id::aboutid::image  | ưȥåХåޤ                  |
|               | id::detailid:+  |                                                 |
|               |                               |                                                 |
| questionˡ  | question::title           | ϸϤƤʤ˥󥯤                      |
|               | question::detail          | ưȥåХåޤ                  |
|               | question::image           |                                                 |
|               |                               |                                                 |
| searchˡ    | [search:]                 | ϤƤʸθ̤˥󥯤ޤ              |
|               | [search:keyword:]         |                                                 |
|               | [search:question:]        |                                                 |
|               | [search:asin:]            |                                                 |
|               | [search:web:]             |                                                 |
|               |                               |                                                 |
| antennaˡ   | a:id:                     | ϤƤʥƥʤ˥󥯤ޤ                    |
| bookmarkˡ  | b:id: (:)             | ϤƤʥ֥åޡ˥󥯤ޤ                |
|               | [b:id::t:]            |                                                 |
|               | [b:t:]                    |                                                 |
|               | [b:keyword:]              |                                                 |
|               |                               |                                                 |
| diaryˡ     | d:id:                     | ϤƤʥ꡼˥󥯤                    |
|               | d:id:+                | ưȥåХåޤ                  |
|               | [d:keyword:]              |                                                 |
|               |                               |                                                 |
| fotolifeˡ  | f:id:::image          | ϤƤʥեȥ饤դμ̿ɽ              |
|               | f:id:::movie          | ưȥåХåޤ                  |
|               | f:id:(:favorite)          |                                                 |
|               |                               |                                                 |
| groupˡ     | g:                        | ϤƤʥ롼פ˥󥯤                      |
|               | g::id:                | ưȥåХåޤ                  |
|               | [g::keyword:]¾     |                                                 |
|               |                               |                                                 |
| haikuˡ     | [h:keyword:]              | ϤƤʥϥ˥󥯤ޤ                      |
|               | [h:id:]                   |                                                 |
|               |                               |                                                 |
| ideaˡ      | idea: (:title)            | ϤƤʥǥ˥󥯤                      |
|               | i:id:                     | ưȥåХåޤ                  |
|               | [i:t:]                    |                                                 |
|               |                               |                                                 |
| rssˡ       | r:id:                     | ϤƤRSS˥󥯤ޤ                         |
| graphˡ     | graph:id:                 | ϤƤʥդɽ󥯤ޤ              |
|               | [graph:id:: (:image)] |                                                 |
|               | [graph:t:]                |                                                 |
|               |                               |                                                 |
| keywordˡ   | [[[[]]]]                      | ɤ˥󥯤ޤ                        |
|               | [keyword:]                |                                                 |
|               | [keyword::graph]¾      |                                                 |
|               |                               |                                                 |
| isbn/asinˡ | isbn:             | ҡڡǲʤɤξҲ󥯤ɽޤ    |
|               | asin:                     |                                                 |
|               | isbn::title               |                                                 |
|               | isbn::image               |                                                 |
|               | isbn::detail¾          |                                                 |
|               |                               |                                                 |
| rakutenˡ   | [rakuten:]                | ŷԾξʤξҲ󥯤ɽޤ          |
| jan/eanˡ   | jan: ean:¾       | JAN/EANɤȤäʾҲ󥯤ɽޤ |
| ugomemoˡ   | ugomemo:                  | Žդޤ                          |
|---------------+-------------------------------+-------------------------------------------------|
")

(defvar hatena-help-syntax-other
  'dummy
  "ϻٱ絡ǽ

|--------------------------------------+----------------------------------------------------------|
| إ                               |                                                      |
|--------------------------------------+----------------------------------------------------------|
| *פ-פ򤽤Τޤ޹Ƭɽ | ʹƬȾѤζĤ                             |
| 񤭵ˡ                           | <!--  -->                                            |
| ¸ǽ                     | <ins>  </ins>, <del>  </del>                     |
| citetitle°                      | <blockquote cite=\"\" title=\"\">  </blockquote> |
| ư󥯤򥿥ǻȤ             | <a href=\"ϤƤʵˡ\">  </a>                          |
|--------------------------------------+----------------------------------------------------------|
")






