#!/usr/bin/perl
#
# hategle.pl - make it possible to write Blogger like HatenaDiary
#
# Copyright (C) 2007 by nawota
# <nawota@users.sourceforge.jp>
# http://hakmem.blogspot.com/
#
# $Id: hategle.pl,v 1.7 2007/04/30 12:10:23 nawota Exp $

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
use warnings;

use LWP::UserAgent;
use HTTP::Headers;
use HTTP::Request::Common;
use IPC::Open2;

sub debug($);
sub read_config();
sub login();
sub get_bid();
sub post($);
sub from_to($$$);

my ($name,$email,$password,$url,$readmore_string,@ping_to,$nkf,$has_ssl,$stunnel,
    $stunnel_port,$stunnel_verify_level,$amazon_id,$file_encode);
my $debug=0;

read_config;

my $VERSION="0.3";
my $ua=LWP::UserAgent->new(agent => "Hategle/$VERSION",);
my $google_login_url="https://www.google.com/accounts/ClientLogin";
my $stunnel_login_url="http://localhost:$stunnel_port/accounts/ClientLogin";
my $google_post_id="<blog_id>";
my $google_post_url="http://www.blogger.com/feeds/<blog_id>/posts/default";
my $auth;
my $blog_id;
my $blog_name;

my $post_content=<<EOM;
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<entry xmlns='http://www.w3.org/2005/Atom'>
  <title type='text'><!-- subject --></title>
  <!-- timestamp -->
  <content type='xhtml'>
<!-- post -->
  </content>
  <!-- category -->
  <author>
    <name>$name</name>
    <email>$email</email>
  </author>
</entry>
EOM

my $stunnel_conf=<<EOM;
output=/dev/stdout
pid=
client=yes
verify=$stunnel_verify_level
[psuedo-https]
accept  = $stunnel_port
connect = www.google.com:443
EOM

my $ping_xml=<<EOM;
<?xml version="1.0"?>
<methodCall>
<methodName>weblogUpdates.ping</methodName>
<params>
  <param>
    <value><!-- blog_name --></value>
  </param>
  <param>
    <value>$url</value>
  </param>
</params>
</methodCall>
EOM

my $amazon_version="2007-04-04";
my $amazon_url="http://webservices.amazon.co.jp/onca/xml?Service=AWSECommerceService&SubscriptionId=1ASEVG8FCR0Z5PAAEFR2&Version=$amazon_version&Operation=ItemLookup&ResponseGroup=Small,ItemAttributes,Images&AsociateID=$amazon_id&ItemId=";

my $has_encode;
if($has_encode=eval('use Encode; 1')) {
    debug "Using Encode to encode\n";
}else{
    debug "Using nkf to encode\n";
}
from_to($readmore_string,$file_encode,"utf-8");

# load diary
my $file=shift or die "Usage:$0 <file_to_post>";
my $body="";
open DIARY,"< $file";
my $subject=<DIARY>;chomp $subject;
from_to($subject,$file_encode,"utf-8");
my ($in_pre,$in_deflist,$in_table,$list_level,$readmore,@list_type)=(0,0,0,0,0,());
my @tb_list;
print "reading $file...\n";
while(<DIARY>){
    from_to($_,$file_encode,"utf-8");
    if($in_pre){
	m/^\|\|<$/ and $in_pre=0,$body.="</pre>\n",next;
	s/&/&amp;/g;
	s/</&lt;/g;
	s/>/&gt;/g;
	$body.="$_";
	next;
    }
    if($in_deflist && $_!~m/^:/){$body.="</dl>\n";$in_deflist=0;}
    if($in_table && $_!~m/^\|/) {$body.="</tbody></table>\n";$in_table=0;}

    #isbn check
    if(/^isbn:(.*)$/ || /^asin:(.*)$/){
	sleep 1 if();
	my $res=$ua->request(
	    HTTP::Request::Common::GET($amazon_url.$1));
	if($res->content()=~m/<Eroor>/){
	    print "invalid asin/isbn ID: $1\n";
	}else{
	    $res->content()=~m!<Title>(.*?)</Title>!;
	    my $item_title=$1;

	    $res->content()=~m!<DetailPageURL>(.*?)</DetailPageURL>!;
	    $body.="<a href='$1'>";

	    $body.="<img src='$1' height='$2' width='$3' alt='$item_title' />\n"
		if($res->content()=~m!<MediumImage><URL>(.*?)</URL><Height Units="pixels">(\d+)</Height><Width Units="pixels">(\d+)</Width></MediumImage>!);
	    
	    $body.="$item_title</a>\n";
	    my $text=$res->content();
	    while($text=~s!<Creator Role="(.*?)">(.*?)</Creator>!!){
		$body.="$1:$2\n";
	    }
	    $text=~m!<PublicationDate>(.*?)</PublicationDate>!;
	    my @publish_date=split(/-/,$1);
	    my $iteminfo="";
	    for(my $i=0;$i<3;$i++){
		if(defined $publish_date[$i]){
		    if($i==0){
			$iteminfo.=$publish_date[$i]."ǯ";
		    }elsif($i==1){
			$iteminfo.=$publish_date[$i]."";
		    }else{$iteminfo.=$publish_date[$i]."";}
		}
	    }
	    $iteminfo.="ȯ\n";

	    $text=~m!<Publisher>(.*?)</Publisher>!;
	    $iteminfo.="丵: ";
	    from_to($iteminfo,"euc-jp","utf-8");
	    $body.=$iteminfo.$1."\n";
	}
	next;
    }

    #TB chechk
    if(/^TB:(.*)$/){
	push @tb_list,$1;
	next;
    }

    #list check
    if(/^([-+]*)(.*)$/){
	my $curlv=length($1);
	my $cur_type=(pop @list_type);
	my $tag= (substr($1,0,1) eq "-")?"ul":"ol";

	if(defined $cur_type){
	    $curlv=0 if($tag ne $cur_type);
	    push @list_type,$cur_type;
	}
	while($list_level>$curlv){
	    $body.="</li>\n</".(pop @list_type).">\n";
	    $list_level--;
	}
	$curlv=length($1);

	if($curlv){
	    if($curlv > $list_level){
		chomp $body;
		$body.="\n<$tag>\n";
		push @list_type,$tag;
		$list_level++;
	    }else{
		$body.="</li>\n";
	    }
	    my $item=$2;
	    unless(m/^(.*)\|<$/) {$body.="<li>$item";}
	    else {
		$body.="<li>$1";
		while($list_level>$curlv){
		    $body.="</li>\n</".(pop @list_type).">\n";
		    $list_level--;
		}
		$body.="</pre>\n";
	    }
	    next;
	}
    }

    m/^>>$/         and $body.="<blockquote><div>\n"  ,next;
    m/^<<$/         and $body.="</div></blockquote>\n" ,next;
    m/^>\|\|$/      and $in_pre=1,$body.="<pre>\n",next;
    m/^>\|$/        and $body.="<pre>\n"         ,next;
    m/^(.*)\|<$/    and $body.="$1</pre>\n"      ,next;
    m/^\*\*\*(.*)$/ and $body.="<h5>$1</h5>\n"   ,next;
    m/^\*\*(.*)$/   and $body.="<h4>$1</h4>\n"   ,next;

    if(m/^====$/ && !$readmore){
	$body.="<div class='fullpost'>\n<a name='readmore-anc' id='readmore-anc'></a>\n";
	$readmore=1;
	next;
    }

    if(m/^:(.*?):(.*)$/){
	$body.="<dl>\n" unless($in_deflist);
	$in_deflist=1;
	$body.="<dt>$1</dt>\n<dd>$2</dd>\n";
	next;
    }
    if(m/^(\|.*\|)$/){
	my $text=$1;
	$body.="<table><tbody>\n" unless($in_table);
	$in_table=1;
	while($text=~m/\|.+$/){
	    $text=~s/\|(.*?)\|/<td>$1<\/td>|/
		unless($text=~s/\|\*(.*?)\|/<th>$1<\/th>|/);
	}
	$text="<tr>$text";
	$text=~s/\|$/<\/tr>\n/;
	$body.=$text;
	next;
    }

    s/ \*/*/;s/ -/-/;s/ \+/+/;

    chomp;
    $body.="$_\n";
}
while($list_level){
    $body.="</li>\n</".(pop @list_type).">\n";
    $list_level--;
}
#$body.="</div>\n";
close DIARY;
print "...done\n";

get_bid;
login;

my $category="";
$category.="<category scheme='http://www.blogger.com/atom/ns#' term='$1'></category>" while($subject=~s/\[(.*?)\]//);

my $published="";
if($readmore){
    $body.="</div>\n<div class='readmore'>\n";
    $post_content=~s/<!-- subject -->/$subject/;
    my $res=post "POST";
    debug "$res\n";
    $res =~ m!(<id>.*?</published>).*?<link rel='alternate' type='text/html' href='(.*?)'></link>.*?<link rel='edit' type='application/atom\+xml' href='(.*?)'></link>!;

    $published=$1;
    $body.="<a href='$2#readmore-anc'>$readmore_string</a>\n</div>";
    $google_post_url=$3;
}

for($post_content){
    s/<!-- subject -->/$subject/;
    s/<!-- post -->/$body/;
    s/<!-- category -->/$category/;
}
my $post_res= post ($readmore?"PUT":"POST");
debug $post_res;
print "your entry has post\n";

# ping
foreach(@ping_to){
    print "pinging to $_...\n";
    $ping_xml =~ s/<!-- blog_name -->/$blog_name/;
    my $head=new HTTP::Headers('Content_Type' =>
			       'application/atom+xml; charset=UTF-8',
			       'Authorization' => "GoogleLogin auth=$auth",);
    my $req=HTTP::Request->new(POST => $_,$head,$ping_xml);
    debug $req->as_string()."\n";
    my $res=$ua->request($req);
    debug $res->as_string()."\n";
    print "Error!" unless($res->is_success);
    print "...done\n";
}

# TrackBack
if($#tb_list!=-1){
    my $ent_url;

    $body=~s/<div class='fullpost'>.*$//s;
    $body=~s/<.*?>//g;

    $post_res =~
	m!<id>.*?</published>.*?<link rel='alternate' type='text/html' href='(.*?)'></link>.*?<link rel='edit' type='application/atom\+xml' href='(.*?)'></link>!;
    $ent_url=$2;

    foreach(@tb_list){
	print "trackback to $_...\n";
	my $res=$ua->request(
	    HTTP::Request::Common::POST($_,
					['title' => $subject,
					 'excerpt' => $body,
					 'url' => $ent_url,
					 'blog_name' => $blog_name]));
	debug $res->as_string()."\n";
	$res=~m!<error>(.*?)</error>!;

	print "trackback to $_ ... OK\n" if($1 eq "0");
	print "Error!" unless($res->is_success);
	print "...done\n";
    }
}

# sub routines
sub debug($){
    print shift if($debug);
}

sub login(){
    return if(defined $auth);
    my %form=(
	'accountType' => 'HOSTED_OR_GOOGLE',
	'Email'       => $email,
	'Passwd'      => $password,
	'service'     => 'blogger',
	'source'      => 'nawota-hate2blogger-test',);

    my $res;
    if($has_ssl){
	debug "Using SSLeay for https connection\n";
	$res=$ua->request(
	    HTTP::Request::Common::POST("$google_login_url", \%form));
    }else{
	debug "Using stunnel for https connection\n";
	use IPC::Open2;

	local (*Reader,*Writer);
	my $pid=open2(\*Reader,\*Writer,"$stunnel -fd 0");
	print Writer $stunnel_conf;
	close Writer;
	while(<Reader>){
	    last if(/500 clients allowed/);
	}
	close Reader;
	$res=$ua->request(
	    HTTP::Request::Common::POST($stunnel_login_url, \%form));
	kill $pid;
	debug "waiting for stunnel\n";
	waitpid $pid,0;
    }
    debug $res->as_string()."\n";
    die "Authorization Failed:Please check your configuration"
	if($res->as_string()=~/Error=BadAuthentication/);
    die "Error!" unless($res->is_success);
    $res->content() =~ m/^Auth=(.*)$/m;
    $auth=$1;
    debug "auth:$auth\n";
}

sub get_bid(){
    return if(defined $blog_id);
    # get blog id
    my $res=$ua->request(
	HTTP::Request::Common::GET($url."feeds/posts/default"));
    die "Error!" unless($res->is_success);
    $res->content() =~ m!<id>tag:blogger.com,1999:blog-(\d+)</id>!;
    $blog_id=$1;
    debug "blog_id:$blog_id\n";
    $res->content() =~ m!<title type='text'>(.*?)</title>!;
    $blog_name=$1;
    debug "blog_name:$blog_name\n";
}

sub post($){
    my $method=shift;
    # post
    $google_post_url=~s/$google_post_id/$blog_id/;
    my $head=new HTTP::Headers('Content_Type' => 'application/atom+xml; charset=UTF-8',
			       'Authorization' => "GoogleLogin auth=$auth",);
    my $req;
    if($method eq "POST"){
	$req=HTTP::Request->new(POST => "$google_post_url",$head,$post_content);
    }else{
	$req=HTTP::Request->new(PUT => "$google_post_url",$head,$post_content);
    }
    debug $req->as_string()."\n";
    my $res=$ua->request($req);
    debug $res->as_string()."\n";
    die "Error!" unless($res->is_success);
    return $res->as_string;
}

sub read_config(){
    print "reading config...\n";

    #default values
    $has_ssl=1;
    $stunnel_port=8080;
    $stunnel_verify_level=0;
    $amazon_id="";

    open CONF,"< $ENV{HOME}/.hategle.conf" or
	open CONF,"< ./hategle.conf" or
	die "failed to open ~/.hategle.conf or ./hategle.conf:$!";
    while(<CONF>){
	next if(/^\s*#/ or /^\s*$/);
	chomp;
	s/^\s*(\S+)\s*=\s*(.*)$/$1="$2"/;

	if(/^ping_to="(.*)"$/){
	    @ping_to=split (/,/,$1);
	    next;
	}

	s/(\$|@|%)/\\$1/g;
	s/^/\$/;
	eval;
    }
    close CONF;
    print "...done\n";
}

sub from_to($$$){
    my ($text,$from,$to)=@_;
    my %opt    = (
	'euc'  => 'e','euc-jp'  => 'e',
	'jis'  => 'j',
	'sjis' => 's',
	'utf'  => 'w','utf-8'  => 'w'
	);
    return length($text) if(defined $opt{$from} && defined $opt{$to} &&
			    $opt{$from} eq $opt{$to});
    return Encode::from_to($text,$from,$to) if($has_encode);
    local (*Reader,*Writer);
    my $pid_get=open2(\*Reader,\*Writer,"$nkf -$opt{$to}");
    print Writer $text;
    close Writer;
    my $res="";
    $res.=$_ while(<Reader>);
    $_[0] = $text=$res;
    close Reader;
    return length($text);
}
