// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		AWTDispatchCommandQueue.java
//	DATE:		2003.7.10	initial version
//	MODIFIED:	2003.9.13	ۂɓ]R}h awt CxgC[番
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.view.awt;

import jp.gr.java_conf.ktz.puzzle.framework.util.CommandQueue;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;

import jp.gr.java_conf.ktz.puzzle.framework.view.command.AbstractCommand;

/**
 *	CommandzM邽߂̃C^[tF[X
 */
public class AWTDispatchCommandQueue implements CommandQueue {
	private static class Holder {
		static CommandQueue sInstance = new AWTDispatchCommandQueue();
	}
	
	public static void postCommand(Command inCommand) {
		Holder.sInstance.post(new AWTDispatchCommand(inCommand));
	}
	
	/**
	 *	CommandzM
	 *
	 *	@param	inCommand	zMCommand
	 */
	public void post(Command inCommand) {
		java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent((java.awt.AWTEvent)inCommand);
	}
}