//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		AbstractDecoratedModel.java
//	DATE:		2003.6.4	initial version
//	MODIFIED:	2003.7.14	ԑJڃ\bhTemplate Method
//	MODIFIED	2003.8.13	bvModelԂ悤ύX(protected)
//	MODIFIED	2003.8.19	addModelɂāAModelŉwAbstractDecoratedModel̉ɗ悤ɂ
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.model;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

/**
 *	Decoraterp^[ŎfB
 *	ł́AׂĂ͓̎qõ\bhĂԂB
 *	<code>AbstractDecoratedModel</code>gNXŁA
 *	KvɉāA\bhI[o[Ch邱
 */
public abstract class AbstractDecoratedModel implements Model {
	/** qɂ郂f */
	protected Model mModel;
		
	/**
	 *	ftHgRXgN^
	 *	NullModelœqf
	 */
	protected AbstractDecoratedModel() {
		this(NullModel.getInstance());
	}
		
	/**
	 *	RXgN^
	 *
	 *	@param	inModel	qɂ郂f
	 */
	protected AbstractDecoratedModel(Model inModel) {
		addModel(inModel);
	}
	
	/**
	 *	gŃbvModelZbg
	 *	ݍŏʂModel͎w肵ModelKŵŉw
	 *	AbstractDecoratedModel̎qModelƂȂ悤ɉB
	 *
	 *	@param	inModel	gŃbvModel
	 */
	public void addModel(Model inModel) {
		Model aModel = getDecorated();
		if (! (aModel instanceof NullModel) || null != aModel) {
			if (aModel instanceof AbstractDecoratedModel) {
				((AbstractDecoratedModel)aModel).addModel(inModel);
				return;
			}
		}

		mModel = inModel;
	}
	
	/**
	 *	@return	gbvModelԂ
	 */
	protected Model getDecorated() {
		return mModel;
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬B
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	public final void createBoard(final int inWidth, final int inHeight) {
		createBoardSelf(inWidth, inHeight);
		
		mModel.createBoard(inWidth, inHeight);
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬B
	 *	œ̏s
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	protected abstract void createBoardSelf(final int inWidth, final int inHeight);
	
	/**
	 *	ݒ肷B
	 *
	 * 	@param	inProblem	̏
	 *	@return	ǂ݂񂾗vf
	 */
	public int setProblem(ProblemInfo inProblem) {
		return mModel.setProblem(inProblem);
	}
	
	/**
	 *	݂̏Ԃǂ`FbNB
	 *
	 *	@return ȂtrueԂ
	 */
	public boolean check() {
		return mModel.check();
	}
	
	/**
	 *	Ԃɖ߂
	 */
	public void reset() {
		mModel.reset();
	}
	
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	public void resetAt(final int inX, final int inY) {
		resetAtSelf(inX, inY);
		mModel.resetAt(inX, inY);
	}
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	protected abstract void resetAtSelf(final int inX, final int inY);
	
	/*
	 *	Model̏ԂύX(optional operation)
	 *
	 *	@param	inState	ύX̏
	 */
	public void setModelState(ModelState inState) {
		if (acceptableModelState(inState)) {
			setModelStateSelf(inState);
		}
		
		mModel.setModelState(inState);
	}
	
	/**
	 *	w肵ModelStateModelŎ󂯓邱Ƃo邩ǂ`FbN
	 *	̎ł́AfalseԂBKvɉāAI[o[ChB
	 *	(optional operation)
	 *
	 *	@param	inState `FbN
	 *
	 *	@return	󂯓邱ƂôȂAtrueԂ
	 */
	protected boolean acceptableModelState(ModelState inState) {
		return false;
	}
	
	/*
	 *	Model̏ԂύX(optional operation)
	 *	ftHg͉̎ȂB
	 *
	 *	@param	inState	ύX̏
	 */
	protected void setModelStateSelf(ModelState inState) {
	}
	
	/**
	 *	{[h̃TCYԂ 
	 *
	 *	@return TCY
	 */
	public java.awt.Dimension getSize() {
		return mModel.getSize();
	}
	
	/**
	 *	{[h̕Ԃ 
	 *
	 *	@return 
	 */
	public int getWidth() {
		return mModel.getWidth();
	}
	
	/**
	 *	{[h̍Ԃ 
	 *
	 *	@return 
	 */
	public int getHeight() {
		return mModel.getHeight();
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY) {
		return mModel.getCurStateAt(inX, inY);
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̐ԂԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCorrectStateAt(final int inX, final int inY) {
		return mModel.getCorrectStateAt(inX, inY);
	}

	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	protected abstract boolean isAcceptableEvent(StateEventCode inCode);

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂B
	 *
	 * 	@param inX	XW
	 *	@param	inY	YW
	 */
	public void nextStateAt(final int inX, final int inY) {
		mModel.nextStateAt(inX, inY);
	}
	
	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	public void nextStateAt(final int inX, final int inY, StateEventCode inCode) {
		if (isAcceptableEvent(inCode)) { 
			nextStateAtSelf(inX, inY, inCode);
		}
		
		mModel.nextStateAt(inX, inY, inCode);
	}
	
	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected abstract void nextStateAtSelf(final int inX, final int inY, StateEventCode inCode);

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂B
	 *
	 * 	@param inX	XW
	 *	@param	inY	YW
	 */
	public void prevStateAt(final int inX, final int inY) {
		mModel.prevStateAt(inX, inY);
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	public void prevStateAt(final int inX, final int inY, StateEventCode inCode) {
		if (isAcceptableEvent(inCode)) {
			prevStateAtSelf(inX, inY, inCode);
		}
		
		mModel.prevStateAt(inX, inY, inCode);
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected abstract void prevStateAtSelf(final int inX, final int inY, StateEventCode inCode);

	/** 
	 *	ŌɏCʂ̈ʒuԂ
	 *	̎ł́AׂĂModelKwǂāACʂ̈ʒuW
	 *
	 *	@return ŌɏCʂ̈ʒuԂ
	 */
	public final java.awt.Point[] lastModified() {
		java.awt.Point[] aPos1 = mModel.lastModified();
		java.awt.Point[] aPos2 = lastModifiedSelf();
		
		if (0 == aPos1.length) {
			return aPos2;
		}
		
		if (0 < aPos2.length) {
			java.util.Set aSet = new java.util.HashSet();
			
			aSet.addAll(java.util.Arrays.asList(aPos1));
			aSet.addAll(java.util.Arrays.asList(aPos2));
			
			java.awt.Point[] aRet = (java.awt.Point[])aSet.toArray(new java.awt.Point[aSet.size()]);
			aSet.clear();
			
			return aRet;
		}
		
		return aPos1;
	}
	
	/** 
	 *	@return ŌɏCʂ̈ʒuԂ
	 */
	protected abstract java.awt.Point[] lastModifiedSelf();
	
	/**
	 *	w肳ꂽʒu{[ḧǂׂ 
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return	{[ḧȂtrue
	 */
	public boolean contains(final int inX, final int inY) {
		return mModel.contains(inX, inY);
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *
	 *	@param	inX XW
	 *	@param	inY YW
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(final int inX, final int inY) {
		return mModel.isTransitAt(inX, inY);
	}
	
	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *
	 *	@param	inX XW
	 *	@param	inY YW
	 *	@param	inTransitCode JڂɊւl
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(
			final int inX, final int inY, 
			StateEventCode inTransitCode)
	{
		return mModel.isTransitAt(inX, inY, inTransitCode);
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ󔒂ǂׂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return	󔒂Ȃtrue
	 */
	public boolean isSpaceAt(final int inX, final int inY) {
		return mModel.isSpaceAt(inX, inY);
	}
	
	/**
	 *	w肳ꂽʒu̖ʂǂׂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return	Ȃtrue
	 */
	public boolean isNumberAt(final int inX, final int inY) {
		return mModel.isNumberAt(inX, inY);
	}

	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *	̎ł́AModelKŵA1łύXF߂trueԂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	public final boolean isModified() {
		return (mModel.isModified() || isModifiedSelf()) ? true : false;
	}
	
	/**
	 *	gModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected abstract boolean isModifiedSelf();
	
	/**
	 *	Model̕ύXNA
	 *	̎ł́AׂĂModelKwǂ悤ɂĂ
	 *	XModel̎ɂĂflushSelfI()
	 */
	public final void flush() {
		mModel.flush();
		
		flushSelf();
	}
	
	/**
	 *	Model̕ύXNA
	 */
	protected abstract void flushSelf();
}	
	