//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		ProblemInfo.java
//	DATE:		2003.6.18	intial version
//	MODIFIED	2003.8.17	vf̏WƂāAjava.util.ListŎwł悤C
//							ǂݍ݂łdg݂
//	MODIFIED	2003.9.24	薼ƃCfbNXǉ
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;

import java.util.List;
/**
 *
 *	̏W񂷂C^[tF[X
 *
 */
public class ProblemInfo {
	/** 肪ۑĂt@C */
	private String mFileName;
	
	/** ̖̃CfbNX */
	private int mIndex;
	
	/** Ֆʂɑ΂As[XʒũItZbg */
	private int mOffset;
	
	/** xɓǂ݂ޗvf */
	private int mReadOnce;
	
	/**	̃s[X */
	private int mWidth;
	
	/** ̃s[X */
	private int mHeight;
	
	/** es[XRecordi[List */
	private List mPieceRecords;
	
	/** ǂݍ݂sǂ߂tO */
	private boolean mIsDivideRead;
	
	/**
	 *	RXgN^
	 *	
	 *	@param	inWidth ̃s[X
	 *	@param	inHeight ̃s[X
	 *	@param	inProblem eX̃s[X𕶎\ƂĒ
	 */
	public ProblemInfo(String inFileName, final int inIndex, 
			final int inWidth, final int inHeight, String[] inProblem) 
	{
		this (0, inWidth * inHeight, inFileName, inIndex, 
			inWidth, inHeight, java.util.Arrays.asList(inProblem), false
		);
	}
	
	/**
	 *	RXgN^
	 *	
	 *	@param	inFileName	ۑĂt@C
	 *	@param	inIndex	t@C̖̈ʒu
	 *	@param	inWidth ̃s[X
	 *	@param	inHeight ̃s[X
	 *	@param	inProblem eX̃s[XCollectionƂĎw
	 */
	public ProblemInfo(String inFileName, final int inIndex, 
			final int inWidth, final int inHeight, List inProblem) {
		this (0, inWidth * inHeight, inFileName, inIndex, 
			inWidth, inHeight, inProblem, false
		);
	}

	/**
	 *	RXgN^
	 *	
	 *	@param	inOffset s[XʒũItZbg
	 *	@param	inReadOnce xɓǂ݂ޗvf
	 *	@param	inFileName	ۑĂt@C
	 *	@param	inIndex	t@C̖̈ʒu
	 *	@param	inWidth ̃s[X
	 *	@param	inHeight ̃s[X
	 *	@param	inRecords es[XRecordi[List
	 */
	ProblemInfo(final int inOffset, final int inReadOnce,  
				String inFileName, final int inIndex, 
				final int inWidth, final int inHeight, 
				List inRecords, final boolean inIsDivideRead) 
	{
		mOffset = inOffset;
		mFileName = inFileName;
		mIndex = inIndex;
		mWidth = inWidth;
		mHeight = inHeight;
		mPieceRecords = inRecords;
		mIsDivideRead = inIsDivideRead;
		
		int aReadOnce = inReadOnce;
		// ǂݍݗvfSvfI[o[ꍇ
		if (inOffset + inReadOnce > inRecords.size()) {
			aReadOnce = inRecords.size() - inOffset;
		}
		
		mReadOnce = aReadOnce;
	}
	
	/**
	 *	ǂݍ݂s߂̃RXgN^
	 *
	 *	@param	inOffset	ǂ݂݊Jnn_
	 */
	public ProblemInfo(final int inOffset, final int inReadOnce, ProblemInfo inInfo) {
		this (inOffset, inReadOnce, inInfo.mFileName, inInfo.mIndex, 
			 inInfo.mWidth, inInfo.mHeight, inInfo.mPieceRecords, true
		);
	}
	
	/**
	 *	@return 薼ԂB
	 *	tH[}bg 'file-name#index'ł
	 */
	public String getProblemName() {
		return mFileName + '#' + mIndex;
	}
	
	/**
	 *	@return 蕶Ԃ
	 */
	public Object getRecordAt(final int inIndex) {
		return mPieceRecords.get(inIndex);
	}
	
	/**
	 *	@return	Ֆʂɑ΂As[XʒũItZbgԂ
	 */
	public int getOffset() {
		return mOffset;
	}
	
	/**
	 *	@return	xɓǂ݂ޗvfԂ
	 */
	public int getReadOnce() {
		return mReadOnce;
	}

	/**
	 *	𕪊ēǂ݂ނǂ`FbN
	 *
	 *	@return	ēǂ݂ޏꍇAtrueԂ
	 */
	public boolean isDivideRead() {
		return mIsDivideRead;
	}
	
	/**
	 *	Offsetʒu܂̗vfǂ݂ނƂo邩ǂ`FbN
	 *
	 *	@return	܂̗vfǂ݂ނƂoꍇAtrueԂ
	 */
	public boolean isMoreRead() {
		return mOffset < mPieceRecords.size();
	}
	
	/**
	 *	@return {[h̕Ԃ
	 */
	public int getWidth() {
		return mWidth;
	}
	
	/**
	 *	@return {[h̍Ԃ
	 */
	public int getHeight() {
		return mHeight;
	}

	public String toString() {
		return ProblemInfo.class + " [mWidth : " + mWidth + ", mHeight : " + mHeight
				+ ", record : " + mPieceRecords + "]";
	}
}
