//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Queue_2.java
//	DATE:		2003.7.22
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

class Queue_3 implements QueueIF {
	private Object[] mEnqueueBuf;
	private Object[] mDequeueBuf;
	private int mEnQueueBufSize;
	private int mDeQueueBufSize;
	private int mCurPos;
	
	private java.util.Comparator mComp;
	
	private int mInitialSize;
	
	public Queue_3(java.util.Comparator inComp) {
		mComp = inComp;
	}
	
	public void enqueue(Object inRec) {
		mEnqueueBuf[mEnQueueBufSize++] = inRec;
	}
	
	public Object dequeue() {
		if (0 > --mDeQueueBufSize) {
			sort();
			--mDeQueueBufSize;
		}

/*		
		Object aRet = mDequeueBuf[mDeQueueBufSize];
		mDequeueBuf[mDeQueueBufSize] = null;
*/
		Object aRet = mDequeueBuf[mCurPos++];
		
		return aRet;
	}
	
	public void addAll(Object[] inContainer) {
	}
	
	public void flip() {
	}
	
	public void clear() {
/*
		mEnqueueBuf = new Object[inRecords.length];
		mDequeueBuf = new Object[inRecords.length];
		
		System.arraycopy(inRecords, 0, mEnqueueBuf, 0, mEnqueueBuf.length);
		
		mEnQueueBufSize = mEnqueueBuf.length;
*/
	}
	
	public void sort() {
		if (mInitialSize < size()) {
			mInitialSize = size();
		}

		if (mInitialSize / size() < 4) {
//			java.util.Arrays.sort(mEnqueueBuf, 0, mEnQueueBufSize, mComp);
			heapSort(mEnqueueBuf, 0, mEnQueueBufSize, mComp);
			
			System.out.println("queue sorted. (" + mEnQueueBufSize + " leaves.)");
			printQueue();
		}
		
		Object[] aTemp = mDequeueBuf;
		mDequeueBuf = mEnqueueBuf;
		mDeQueueBufSize = mEnQueueBufSize;
		
//		mEnqueueBuf = new Object[mDeQueueBufSize];
		mEnqueueBuf = aTemp;
		mEnQueueBufSize = 0;
		mCurPos = 0;
	}

	
	public boolean isEmpty() {
		return (mDeQueueBufSize + mEnQueueBufSize == 0);
	}
	
	public int size() {
		return mDeQueueBufSize + mEnQueueBufSize;
	}
		
	public void printQueue() {
		System.out.println("-------------------------------------------");
		System.out.println("print queue entry.");
		for (int i = 0; i < size(); ++i) {
			System.out.println(mEnqueueBuf[i]);
		}
		System.out.println();
	}

	private void pushHeap(
			Object[] inArray, 
			final int inBegin, final int inEnd, 
			java.util.Comparator inComp) 
	{
		int aIndex = inEnd - inBegin -1;
		int aPredecessor = (aIndex-1)/2;
		
		// Ō̗vfۑ
		Object aTemp = inArray[aIndex];
		
		while (aPredecessor != aIndex 
				&& 0 < inComp.compare(inArray[aPredecessor], aTemp)) 
		{
			// vf𒾂܂
			inArray[aIndex] = inArray[aPredecessor];
			
			aIndex = aPredecessor;
			aPredecessor = (aIndex-1)/2;
		}
		
		inArray[aIndex] = aTemp;
	}
	
	private void popHeap(
			Object[] inArray, 
			final int inBegin, final int inEnd, 
			java.util.Comparator inComp) 
	{
		int aIndex = 0;
		int aSuccessor = 1;
		int aLastPos = inEnd - inBegin -1;
		
		// Ō̗vfۑ
		Object aTemp = inArray[aLastPos];
		
		// 擪vf𖖔ɃRs[
		inArray[aLastPos] = inArray[0];
					
		while (aSuccessor < aLastPos) {
			if (aSuccessor < aLastPos -1
				&& 0 < inComp.compare(inArray[aSuccessor], inArray[aSuccessor +1])) 
			{
				++aSuccessor;
			}
			
			if (0 < inComp.compare(aTemp, inArray[aSuccessor])) {
				// vf𕂂
				inArray[aIndex] = inArray[aSuccessor];			
			
				aIndex = aSuccessor;
				aSuccessor = (aIndex+1)*2 -1;
			}
			else {
				break;
			}
		}
		
		inArray[aIndex] = aTemp;
	}
	
	private void makeHeap(
			Object[] inArray, 
			final int inBeginPos, final int inEndPos, 
			java.util.Comparator inComp) 
	{
		for (int i = 1; i < inEndPos; ++i) {
			pushHeap(inArray, inBeginPos, i, inComp);
		}
	}
	
	private void heapSort(
			Object[] inArray, 
			final int inBeginPos, final int inEndPos, 
			java.util.Comparator inComp) 
	{
		makeHeap(inArray, inBeginPos, inEndPos, inComp);
		
		int aSize = inEndPos;
		while (aSize > 1) {
			popHeap(inArray, inBeginPos, aSize--, inComp);
		}
	}
}
