//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HahsikakeBench.java
//	DATE:		2003.9.15
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.FlowLayout;
import java.awt.Insets;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.BadLocationException;

import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.framework.util.GUIUtility;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.io.XMLProblemReader;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkMediator;

public class HashikakeBench extends JFrame {
	private static final int DEFAULT_SOLVE_COUNT = 5;
	private static final String DEFAULT_DIRECTORY = "problem";
	
	private LabeledTextField mSolvedDirField;
	private LabeledTextField mSolveCountField;
	private boolean mCountEnabled;
	
	protected void frameInit() {
		super.frameInit();
		
		setTitle("Hashikake benchmark tester");
		
		Container aContent = getContentPane();
		aContent.setLayout(new GridBagLayout());
		GridBagConstraints aConstraints = null;
	
		{
			aConstraints = new GridBagConstraints();
			aConstraints.insets = new Insets(2, 2, 2, 2);
			aConstraints.gridx = 0;
			aConstraints.gridy = 0;
			aConstraints.gridwidth = 5;
			aConstraints.fill = GridBagConstraints.BOTH;
			
			String aPath = new java.io.File(DEFAULT_DIRECTORY).getAbsolutePath();
			mSolvedDirField = new LabeledTextField("folder : ", aPath, 24);
			aContent.add(mSolvedDirField, aConstraints);
		}
		
		{
			aConstraints = new GridBagConstraints();
			aConstraints.gridy = 0;
			aConstraints.gridwidth = 1;
			aConstraints.anchor = GridBagConstraints.WEST;

			JButton aButton = new JButton("...");
			aButton.setMargin(new Insets(2, 2, 2, 2));
			aButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent inEvent) {
					String aText = mSolvedDirField.getText();
					
					java.io.File aPath = DirectoryChooser.chooseDirectory(
						(JButton)inEvent.getSource(), new java.io.File(aText)
					);
					
					mSolvedDirField.setText(aPath.getAbsolutePath());
				}
			});
			aContent.add(aButton, aConstraints);
		}
		
		{
			aConstraints = new GridBagConstraints();
			aConstraints.gridy = 1;
			aConstraints.gridwidth = 3;
			aConstraints.fill = GridBagConstraints.HORIZONTAL;
			
			JCheckBox aCheck = new JCheckBox("specifies measurment count");
			aCheck.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent inEvent) {
					mCountEnabled = ! mSolveCountField.isEnabled();
					mSolveCountField.setEnabled(mCountEnabled);
					 
				}
			});
			aContent.add(aCheck, aConstraints);
			
		}
		{
			aConstraints = new GridBagConstraints();
			aConstraints.gridx = 1;
			aConstraints.gridy = 2;
			aConstraints.gridwidth = 2;
			
			mSolveCountField = new LabeledTextField("times : ", String.valueOf(DEFAULT_SOLVE_COUNT), 3);
			mSolveCountField.setEnabled(false);
			
			aContent.add(mSolveCountField, aConstraints);
		}
		{
			aConstraints = new GridBagConstraints();
			aConstraints.gridy = 3;
			aConstraints.gridwidth = 5;
			aConstraints.fill = GridBagConstraints.BOTH;
			aContent.add(new JCheckBox("measuring both reset and solve time", true), aConstraints);
			
		}
		{
			aConstraints = new GridBagConstraints();
			aConstraints.gridy = 4;
			aConstraints.gridx = 5;
			aConstraints.gridwidth = 2;
			aConstraints.insets = new Insets(2, 2, 2, 2);
			
			JButton aStartButton = new ButtonColleague();
			aContent.add(aStartButton, aConstraints);
			
			aStartButton.setText("start");
			aStartButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent inEvent) {
					String aPath = mSolvedDirField.getText();

					int aSolveCount = 5;
					if (mCountEnabled) {
						try {
							aSolveCount = Integer.parseInt(mSolveCountField.getText());
						}
						catch (NumberFormatException e) {
						}
					}
					
					java.io.File aDir = new java.io.File(aPath);
					
					BenchmarkMediator aMediator
						 = HashikakeBenchmarkMediator.getInstance((java.awt.Component)inEvent.getSource());
						 
					aMediator.addColleague((Colleague)inEvent.getSource());
					aMediator.start(aDir, aSolveCount);
				}
			});
		}
	}
	
	private static class LabeledTextField extends JComponent {
		private JTextField mField;
		
		public LabeledTextField(String inLabel, String inInitialText, final int inColumns) {
			setLayout(new FlowLayout());
			
			add(new JLabel(inLabel));
			mField = new JTextField(inInitialText, inColumns);
			add(mField);
		}

		public LabeledTextField(Document inDocument, String inLabel, String inInitialText, final int inColumns) 
		{
			this (inLabel, inInitialText, inColumns);
			
			mField.setDocument(inDocument);
		}

		public void setEnabled(boolean inEnabled) {
			final boolean aOldVal = isEnabled();
			super.setEnabled(inEnabled);
			
			java.awt.Component[] aComps = getComponents();
			for (int i = 0, aCompCount = getComponentCount(); i < aCompCount; ++i) {
				aComps[i].setEnabled(inEnabled);
			}
		}
		
		public String getText() {
			return mField.getText();
		}
		
		public void setText(String inText) {
			mField.setText(inText);
		}
	}
	
	private static class ButtonColleague extends JButton implements Colleague {
		public void setUp() {
			setEnabled(false);
		}
	
		public void cleanUp() {
			setEnabled(true);
		}
		
		public void update() {
		}
	}
}