//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BenchmarkResultTableProxy.java
//	DATE:		2003.9.30
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view; 

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import java.awt.BorderLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableCellRenderer;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchReport;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkMediator;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableSortHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.SortStrategy;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.ResultTableModel;

public class BenchmarkResultTableProxy extends AbstractFrameColleague {
	BenchmarkMediator mMediator;
	Colleague mResultTable;
	
	public BenchmarkResultTableProxy(
		BenchmarkMediator inMediator, TableModel inModel, TableSortHandler inSortHandler) 
	{
		BenchmarkResultTable aResultTable
			 = new BenchmarkResultTable(inModel, inSortHandler);
		aResultTable.addWindowListener(getDefaultWindowListener());
		
		mMediator = inMediator;
		mResultTable = aResultTable;
	}
	
	protected void colleagueCloseOperation() {
		mMediator.colleagueChanged(this);
	}
	
	public void setUp() {
		mResultTable.setUp();
	}
	
	public void update() {
		mResultTable.update();
	}
	
	public void cleanUp() {
		mResultTable.cleanUp();
		
		mMediator = null;
		mResultTable = null;
	}
}

class BenchmarkResultTable extends JFrame implements Colleague {
	private TableSortHandler mSortHandler = new NullSorter();
	
	public BenchmarkResultTable(TableModel inModel, TableSortHandler inSortHandler) {
		if (null != inSortHandler) mSortHandler = inSortHandler;

		JFrame f = new JFrame("result table");
		JTable aTable = new JTable();
		aTable.setModel(inModel);
		aTable.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
		aTable.setShowVerticalLines(false);
		aTable.setColumnSelectionAllowed(true);
		
		BenchResultCellRenderer aCellRenderer = new BenchResultCellRenderer();
		ClickableHeaderRenderer aHeaderRenderer = new ClickableHeaderRenderer(aCellRenderer);
		aTable.setDefaultRenderer(Object.class, aCellRenderer);
		aTable.getTableHeader().setDefaultRenderer(aHeaderRenderer);
		aTable.getTableHeader().addMouseListener(aHeaderRenderer);
		
		JScrollPane aScroller = new JScrollPane(aTable);
		
		getContentPane().add(aScroller, BorderLayout.CENTER);
		f.pack();
	}
	
	public void setUp() {
		pack();
		setVisible(false);
	}
	
	public void cleanUp() {
		WindowListener[] aListeners = getWindowListeners();
		
		for (int i = 0; i < aListeners.length; ++i) {
			removeWindowListener(aListeners[i]);
		}
		
		addWindowListener(new StandaloneWindowHandler());
		
		mSortHandler.sort();
		pack();
		setVisible(true);
	}
	
	public void update() {
		if (! isVisible()) {
			mSortHandler.sort();
		}
		
		setVisible(! isVisible());
	}
	
	public static void main(String[] inArgs) {
		BenchReport[] aData = new BenchReport[] {
			BenchReport.createReport(new ProblemInfo("hashi_02_01", 11, 10, 10, new String[0]), 99, 101, 100, 2),  
			BenchReport.illegalBenchReport(new ProblemInfo("hashi_03_01", 12, 15, 15, new String[0]), 3), 
		};
		
		ResultTableModel aModel = new ResultTableModel(
			new String[] {"problem name", "min time", "max time", "average time", "count", "solved", }
		);	
		
		for (int i = 0; i < aData.length; ++i) {
			aModel.addRow(aData[i].flatten());
		}
		
		new BenchmarkResultTable(aModel, null).setVisible(true);
	}
	
	private class StandaloneWindowHandler implements WindowListener {
		public void windowClosing(WindowEvent inEvent) {
			mSortHandler = null;
			
			((java.awt.Window)inEvent.getSource()).dispose();
		}
		
		public void windowActivated(WindowEvent inEvent) {}
		public void windowDeactivated(WindowEvent inEvent) {}
		public void windowOpened(WindowEvent inEvent) {}
		public void windowClosed(WindowEvent inEvent) {}
		public void windowIconified(WindowEvent inEvent) {}
		public void windowDeiconified(WindowEvent inEvent) {}		
	}
	
	private class BenchResultCellRenderer 
		implements TableCellRenderer, ClickableHeaderObserver
	{
		private final java.awt.Color SORTED_CELL_BACK_COLOR = java.awt.Color.lightGray;
		
		private javax.swing.table.TableCellRenderer mRenderer = new javax.swing.table.DefaultTableCellRenderer();
		private TableColumn mLastClickedColumn;
		
		public BenchResultCellRenderer() {
		}
		
		public void updateLastClickedColumn(TableColumn inColumn) {
			mLastClickedColumn = inColumn;
		}
		
		public java.awt.Component getTableCellRendererComponent(
							JTable inTable, Object inValue,
							boolean inSelected, boolean inFocused, 
							int inRow, int inColumn)
		{
			java.awt.Component aComp
				 = mRenderer.getTableCellRendererComponent(inTable, inValue, inSelected, inFocused, inRow, inColumn);
			
			if (inTable != null) {
				javax.swing.table.JTableHeader aHeader = inTable.getTableHeader();
				if (aHeader != null) {
	                final TableColumn aPaintCol = aHeader.getColumnModel().getColumn(inColumn);
					if (aPaintCol == mLastClickedColumn) {
						aComp.setBackground(SORTED_CELL_BACK_COLOR);
					}
					else {
						aComp.setBackground(java.awt.Color.white);
					}
				}
			}
			
			return aComp;
		}
	}
	
	private class ClickableHeaderRenderer extends javax.swing.JButton 
						implements  TableCellRenderer , MouseListener
	{
		private final java.awt.Insets EMPTY_INSETS = new java.awt.Insets(1, 0, 1, 0);
		private TableColumn mColumn;
		private ClickableHeaderObserver mClickObserver;
		
		public ClickableHeaderRenderer(ClickableHeaderObserver inClickObserver) {
			setMargin(EMPTY_INSETS);
			mClickObserver = inClickObserver;
		}
		
		public java.awt.Component getTableCellRendererComponent(
							JTable inTable, Object inValue,
							boolean inSelected, boolean inFocused, 
							int inRow, int inColumn)
		{
			if (inTable != null) {
				javax.swing.table.JTableHeader aHeader = inTable.getTableHeader();
				if (aHeader != null) {
	                setForeground(aHeader.getForeground());
	                setBackground(aHeader.getBackground());
	                setFont(aHeader.getFont());
	                
	                final javax.swing.table.TableColumn aPaintCol = aHeader.getColumnModel().getColumn(inColumn);
	                final boolean aPressed = (aPaintCol == mColumn ? true : false);
	            	javax.swing.ButtonModel aModel = getModel();
	            	aModel.setArmed(aPressed);
	            	aModel.setPressed(aPressed);
				}
			}
			
			setText((inValue == null) ? "" : inValue.toString());
			
			return this;
		}
		
		public java.awt.Insets getInsets() {
			return EMPTY_INSETS;
		}

		public void mousePressed(MouseEvent inEvent) {
			JTableHeader aHeader = (JTableHeader)inEvent.getSource();
			final int aColIndex = aHeader.getColumnModel().getColumnIndexAtX(inEvent.getX());
			mColumn = aHeader.getColumnModel().getColumn(aColIndex);
			
			// Cell RendererXV
			mClickObserver.updateLastClickedColumn(mColumn);
			
			java.awt.Rectangle aBounds = aHeader.getHeaderRect(aColIndex);
			aHeader.repaint(aBounds);
		}
			
		public void mouseReleased(MouseEvent inEvent) {
			JTableHeader aHeader = (JTableHeader)inEvent.getSource();
			final int aColIndex = aHeader.getColumnModel().getColumnIndexAtX(inEvent.getX());
			java.awt.Rectangle aBounds = aHeader.getHeaderRect(aColIndex);
			aHeader.repaint(aBounds);
			
			mColumn = null;
		}
		
		public void mouseExited(MouseEvent inEvent) {}	
		public void mouseClicked(MouseEvent inEvent) {
			JTableHeader aHeader = (JTableHeader)inEvent.getSource();
			int aColIndex = aHeader.columnAtPoint(inEvent.getPoint());
			aColIndex = aHeader.getColumnModel().getColumn(aColIndex).getModelIndex();
			
			// Ń\[gN
			mSortHandler.sort(aColIndex);
		}
		public void mouseEntered(MouseEvent inEvent) {}
	}
	
	private static class NullSorter implements TableSortHandler {
		public void sort() {}
		public void sort(final int inColumnIndex) {}
		public void setSortStrategy(SortStrategy inStrategy) {}
		public void setModel(TableModel inModel) {}
		
		public int resolveRowIndex(final int inIndex) {
			return inIndex;
		}
	}
}
