//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		AbstractFrameColleague.java
//	DATE:		2003.9.30
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;

public abstract class AbstractFrameColleague implements Colleague {	
	protected abstract void colleagueCloseOperation();
	
	protected final WindowListener getDefaultWindowListener() {
		return new WindowListener() {
			public void windowClosing(WindowEvent inEvent) {	
				colleagueCloseOperation();
			}
			
			public void windowActivated(WindowEvent inEvent) {}
			public void windowDeactivated(WindowEvent inEvent) {}
			public void windowOpened(WindowEvent inEvent) {}
			public void windowClosed(WindowEvent inEvent) {}
			public void windowIconified(WindowEvent inEvent) {}
			public void windowDeiconified(WindowEvent inEvent) {}		
		};
	}
}
