//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashikakeBenchmarkHandler.java
//	DATE:		2003.9.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.model;

import java.math.BigDecimal;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SoluteSeparatedException;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStateModel;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchReport;

public class HashikakeBenchmarkHandler implements BenchmarkHandler {
	private Model mModel;
	private SolverHandler mHandler;
	
	private ProblemInfo mProblem;
	
	public HashikakeBenchmarkHandler() {
		mModel = new SolverStateModel(new  BoardModel());
		mHandler = new HashikakeSolverHandler(mModel);
	}
	
	/**
	 *	ZbgAՖʂ̏s
	 */
	public void reset(ProblemInfo inProblem) {
		mModel.createBoard(inProblem.getWidth(), inProblem.getHeight());
		mModel.setProblem(inProblem);
		mHandler.reset();
		
		mProblem = inProblem;
	}
	
	/**
	 *	w肵񐔁A
	 *
	 *	@param	inTimes	Zbgꂽ
	 *
	 *	@return	񓚌ʂ̏
	 */
	public BenchReport solve(final int inTimes) {
		long aElapsedMinTime = Long.MAX_VALUE;
		long aElapsedMaxTime = Long.MIN_VALUE;
		
		gc();
		
		long aTotalTime = System.currentTimeMillis();
		
		for (int aCount = 0; aCount < inTimes; ++aCount) {

			final long aStartTime =  System.currentTimeMillis();
			
			try {
				mModel.reset();
				mHandler.reset();
				while(! mHandler.nextSoluteAll());
				
				final long aElapsedTime = System.currentTimeMillis() - aStartTime;
				aElapsedMinTime = Math.min(aElapsedMinTime, aElapsedTime);
				aElapsedMaxTime = Math.max(aElapsedMaxTime, aElapsedTime);
			}
			catch (SolveDiscompleteException e) {
				return BenchReport.illegalBenchReport(mProblem, System.currentTimeMillis() - aStartTime);
			}
		}
		
		aTotalTime = System.currentTimeMillis() - aTotalTime;

		return BenchReport.createReport(
			mProblem, aElapsedMinTime, aElapsedMaxTime, aTotalTime/inTimes, inTimes
		);
	}
	
	private void gc() {
		try {
			System.gc();
			Thread.currentThread().sleep(200);
			System.runFinalization();
			Thread.currentThread().sleep(300);

		}
		catch (Exception x) {
			x.printStackTrace(System.out);
		}
	}
}